package cloud.proxi.sdkv3.utils

import kotlin.math.roundToLong

fun Double.roundToDecimals(decimals: Int): Double {
    var dotAt = 1
    repeat(decimals) { dotAt *= 10 }
    val roundedValue = (this * dotAt).roundToLong()
    return (roundedValue / dotAt) + (roundedValue % dotAt).toDouble() / dotAt
}