package cloud.proxi.sdkv3.utils

import kotlinx.serialization.KSerializer
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

class DoubleMediumPrecisionSerializer : KSerializer<Double> {
    override val descriptor: SerialDescriptor =
        PrimitiveSerialDescriptor(
            "kotlinx.serialization.LongAsStringSerializer",
            PrimitiveKind.DOUBLE
        )

    override fun serialize(encoder: Encoder, value: Double) {
        encoder.encodeDouble(value.roundToDecimals(6))
    }

    override fun deserialize(decoder: Decoder): Double {
        return decoder.decodeDouble()
    }
}