package cloud.proxi.sdkv3.utils.geohash

import kotlin.math.abs

/*
* Copyright 2010, Silvio Heuberger @ IFS www.ifs.hsr.ch
*
* This code is release under the Apache License 2.0.
* You should have received a copy of the license
* in the LICENSE file. If you have not, see
* http://www.apache.org/licenses/LICENSE-2.0
*/
/**
 * [WGS84Point] encapsulates coordinates on the earths surface.<br></br>
 * Coordinate projections might end up using this class...
 */
class WGS84Point(val latitude: Double, val longitude: Double) {

    constructor(other: WGS84Point) : this(other.latitude, other.longitude) {}

    override fun toString(): String {
        return "($latitude,$longitude)"
    }

    override fun equals(obj: Any?): Boolean {
        if (obj is WGS84Point) {
            val other = obj
            return latitude == other.latitude && longitude == other.longitude
        }
        return false
    }

    override fun hashCode(): Int {
        var result = 42
        val latBits = latitude.toRawBits()
        val lonBits = longitude.toRawBits()
        result = 31 * result + (latBits xor (latBits ushr 32)).toInt()
        result = 31 * result + (lonBits xor (lonBits ushr 32)).toInt()
        return result
    }

    init {
        require(!(abs(latitude) > 90 || abs(longitude) > 180)) { "The supplied coordinates $this are out of range." }
    }
}