package com.jfplugin.xsql;

import com.jfinal.core.JFinal;
import com.jfinal.kit.StrKit;
import com.jfplugin.xsql.core.Context;
import com.jfplugin.xsql.core.SqlConfigParser;

public class XsqlKit {

	private static SqlConfigParser sqlConfigParser = null;
	
	private static String sqlConfig;
	
	public static void init(SqlConfigParser sqlConfigParser, String sqlConfig) {
		XsqlKit.sqlConfigParser = sqlConfigParser;
		XsqlKit.sqlConfig = sqlConfig;
	}
	
	public static SqlArgs getSqlArgs(String sqlId,Object var){
		if(JFinal.me().getConstants().getDevMode() && StrKit.notBlank(sqlConfig)){
			//开发者模式，重新加载配置
			sqlConfigParser = new SqlConfigParser();
			sqlConfigParser.parser(Thread.currentThread().getContextClassLoader().getResourceAsStream(sqlConfig));
		}
		SqlArgs sqlArgs = new SqlArgs();
		Context ctx = new Context();
		ctx.globalVar = var;
		sqlConfigParser.get(sqlId).execute(ctx, null);
		sqlArgs.sql = ctx.toString();
		sqlArgs.args = ctx.getArgsArray();
		return sqlArgs;
	}
	
}
