package com.jfplugin.xsql;

import java.io.InputStream;

import com.jfinal.plugin.IPlugin;
import com.jfplugin.xsql.core.SqlConfigParser;

/**
 * 
 * @author farmer
 *
 */
public class XsqlPlugin implements IPlugin{
	
	private InputStream in = null;
	
	
	private String sqlConfig;
	
	
	public XsqlPlugin(String sqlConfig) {
		this(Thread.currentThread().getContextClassLoader().getResourceAsStream(sqlConfig));
		this.sqlConfig = sqlConfig;
	}
	
	public XsqlPlugin(InputStream in) {
		this.in = in;
	}

	@Override
	public boolean start() {
		SqlConfigParser sqlConfigParser = new SqlConfigParser();
		sqlConfigParser.parser(in);
		XsqlKit.init(sqlConfigParser,sqlConfig);
		return true;
	}

	@Override
	public boolean stop() {
		
		return true;
	}

	
	
}
