package com.jfplugin.xsql.core;

import java.io.InputStream;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.jfplugin.xsql.exception.NodeParserException;

/**
 * XML解析
 * @author farmer
 *
 */
public class NodeParser {

	public Document parser(InputStream in){
		return createDocument(in);
	}

	public String attr(Node node,String key){
		Node attr = node.getAttributes().getNamedItem(key);
		if(attr == null){
			return "";
		}
		return attr.getNodeValue();
	}
	
	/**
	 * 创建Document
	 * @param in
	 * @return
	 */
	private Document createDocument(InputStream in) {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(false);
		factory.setNamespaceAware(false);
		factory.setIgnoringComments(true);
		factory.setIgnoringElementContentWhitespace(false);
		factory.setCoalescing(false);
		factory.setExpandEntityReferences(true);
		try {
			return factory.newDocumentBuilder().parse(in);
		} catch (Exception e) {
			throw new NodeParserException("XML解析异常！", e);
		}
	}
	
	
}
