package com.jfplugin.xsql.core;

import java.io.InputStream;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * SQL MAP 解析
 * @author farmer
 *
 */
public class SqlMapParser {

	private NodeParser nodeParser = new NodeParser();
	
	public void parser(InputStream in, SqlStatementMapping statementMapping) {
		Document doc = nodeParser.parser(in);
		NodeList children = doc.getChildNodes();
		for (int i = 0; i < children.getLength(); i++) {
			Node node = children.item(i);
			if("sqlmap".equals(node.getNodeName().toLowerCase())){
				String namespace = nodeParser.attr(node, "namespace");
				NodeList sqlnodes = node.getChildNodes();
				for (int j = 0; j < sqlnodes.getLength(); j++) {
					Node sqlnode = sqlnodes.item(j);
					if("sql".equals(sqlnode.getNodeName().toLowerCase())){
						String id = namespace+"."+nodeParser.attr(sqlnode, "id");
						statementMapping.put(id, StatementBuilder.builder(sqlnode));
					}
				}
			}
		}
	}

}
