package com.jfplugin.xsql.core;

import java.util.HashMap;
import java.util.Map;

import com.jfplugin.xsql.exception.SqlKeyExistException;
import com.jfplugin.xsql.statement.SqlStatement;

/**
 * 
 * @author farmer
 *
 */
public class SqlStatementMapping {

	private Map<String, SqlStatement>  statementMapping = new HashMap<String, SqlStatement>();
	
	public void put(String key , SqlStatement statement){
		if(statementMapping.get(key) != null){
			throw new SqlKeyExistException("SQLID:"+key+"已经存在！");
		}
		statementMapping.put(key, statement);
	}
	
	public SqlStatement get(String key){
		SqlStatement statement = statementMapping.get(key);
		if(statement == null){
			throw new NullPointerException("SQLID:"+ key + "不存在");
		}
		return statement;
	}
	
}
