package com.jfplugin.xsql.core;

import com.jfplugin.xsql.kit.ObjectKit;

/**
 * 变量解析
 * @author farmer
 *
 */
public class VarParser {

	/**
	 * 
	 * @param key
	 * 	变量名
	 * @param globalVar
	 * 	全局变量
	 * @param localVar
	 * 	局部变量
	 * @return
	 * 	返回的对象值
	 */
	public static Object parser(String key, Object globalVar, Object localVar) {
		Object value = parser(key, localVar);
		if(value == null){
			value = parser(key, globalVar);
		}
		return value;
	}

	/**
	 * 
	 * @param key
	 * 	变量名
	 * @param var
	 * 	变量Map
	 * @return
	 * 	返回的对象值
	 */
	public static Object parser(String key, Object var) {
		if(var != null){
			try {
				return ObjectKit.getProperty(var, key);
			} catch (Exception e) {
				e.printStackTrace();
				return null;
			}
		}
		return null;
	}
	
}
