package com.jfplugin.xsql.statement;

import org.w3c.dom.Node;

import com.jfplugin.xsql.core.Context;
import com.jfplugin.xsql.core.VarParser;


/**
 * prepend － 可被覆盖的 SQL 语句组成部分，添加在语句的前面（可选） 
 * property － 被比较的属性（必选）
 * @author farmer
 *
 */
public class IsEmptyStatement extends Statement{

	public IsEmptyStatement(Node node) {
		super(node);
	}

	@Override
	public void execute(Context ctx, Object localVar) {
		String property = attr("property");
		String prepend = attr("prepend");
		Object o = VarParser.parser(property, ctx.globalVar, localVar);
		if(isEmpty(o)){
			ctx.sw.append(prepend);
			for (Statement child : children) {
				child.execute(ctx, localVar);
			}
		}
	}

}
