package com.jfplugin.xsql.statement;

import org.w3c.dom.Node;

import com.jfplugin.xsql.core.Context;
import com.jfplugin.xsql.core.VarParser;

/**
 *  prepend － 可被覆盖的 SQL 语句组成部分，添加在语句的前面（可选） 
 *	property － 被比较的属性（必选） 
 *	compareProperty － 另一个用于和前者比较的属性（必选或选择 compareValue） 
 *	compareValue － 用于比较的值（必选或选择 compareProperty） 
 * @author farmer
 *
 */
public class IsEqualStatement extends Statement{

	public IsEqualStatement(Node node) {
		super(node);
	}

	@Override
	public void execute(Context ctx, Object localVar) {
		String property = attr("property");
		String prepend = attr("prepend");
		String compareProperty = attr("compareProperty");
		String compareValue = attr("compareValue");
		Object o = VarParser.parser(property, ctx.globalVar, localVar);
		if(!isEmpty(compareProperty)){			
			Object o1 = VarParser.parser(compareProperty, ctx.globalVar, localVar);
			if(nullSafeEquals(o,o1)){
				ctx.sw.append(prepend);
				for (Statement child : children) {
					child.execute(ctx, localVar);
				}
			}
		}
		else{
			if(nullSafeEquals(o, compareValue)){
				ctx.sw.append(prepend);
				for (Statement child : children) {
					child.execute(ctx, localVar);
				}
			}
		}
	}

}
