/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.bytecodeupdate;

import codes.rafael.bytecodeupdate.PackageNameRemapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

@Mojo(name="update-bytecode", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class BytecodeUpdateMavenPlugin
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private List<String> artifacts;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter
    private String oldPackage;
    @Parameter
    private String newPackage;
    @Parameter(defaultValue="8", required=true)
    private int javaVersion;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private String outputDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : this.project.getArtifacts()) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException("Failed ro resolve location " + artifact.getFile(), (Throwable)e);
            }
        }
        final URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
        final Remapper remapper = this.oldPackage == null && this.newPackage == null ? new Remapper(){} : new PackageNameRemapper(this.oldPackage.replace('.', '/'), this.newPackage.replace('.', '/'));
        for (Artifact artifact : this.project.getArtifacts()) {
            String value = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
            boolean isRelevant = false;
            if (this.artifacts == null || this.artifacts.isEmpty()) {
                isRelevant = true;
            } else {
                for (String candidate : this.artifacts) {
                    if (!value.matches(candidate)) continue;
                    isRelevant = true;
                    break;
                }
            }
            if (!isRelevant) continue;
            try (JarFile file = new JarFile(artifact.getFile());){
                Enumeration<JarEntry> enumeration = file.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry entry = enumeration.nextElement();
                    if (!entry.getName().endsWith(".class")) continue;
                    boolean isIncluded = false;
                    if (this.includes == null || this.includes.isEmpty()) {
                        isIncluded = true;
                    } else {
                        for (String include : this.includes) {
                            if (!entry.getName().matches(include)) continue;
                            isIncluded = true;
                            break;
                        }
                    }
                    if (this.excludes != null && !this.excludes.isEmpty()) {
                        for (String exclude : this.excludes) {
                            if (!entry.getName().matches(exclude)) continue;
                            isIncluded = false;
                            break;
                        }
                    }
                    if (!isIncluded) continue;
                    try (InputStream inputStream = file.getInputStream(entry);){
                        ClassReader classReader = new ClassReader(inputStream);
                        ClassWriter classWriter = new ClassWriter(2){

                            protected String getCommonSuperClass(String type1, String type2) {
                                Class<?> class2;
                                Class<?> class1;
                                if (remapper instanceof PackageNameRemapper) {
                                    type1 = ((PackageNameRemapper)remapper).reverse(type1);
                                    type2 = ((PackageNameRemapper)remapper).reverse(type2);
                                }
                                try {
                                    class1 = Class.forName(type1.replace('/', '.'), false, classLoader);
                                }
                                catch (Exception e) {
                                    throw new TypeNotPresentException(type1, e);
                                }
                                try {
                                    class2 = Class.forName(type2.replace('/', '.'), false, classLoader);
                                }
                                catch (Exception e) {
                                    throw new TypeNotPresentException(type2, e);
                                }
                                if (class1.isAssignableFrom(class2)) {
                                    return type1;
                                }
                                if (class2.isAssignableFrom(class1)) {
                                    return type2;
                                }
                                if (class1.isInterface() || class2.isInterface()) {
                                    return "java/lang/Object";
                                }
                                while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
                                }
                                return class1.getName().replace('.', '/');
                            }
                        };
                        classReader.accept(new ClassVisitor(393216, (ClassVisitor)new ClassRemapper((ClassVisitor)classWriter, remapper)){

                            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                super.visit(BytecodeUpdateMavenPlugin.this.javaVersion + 44, access, name, signature, superName, interfaces);
                            }
                        }, 0);
                        File output = new File(this.outputDirectory, remapper.map(entry.getName().substring(0, entry.getName().length() - ".class".length()) + ".class"));
                        if (!output.getParentFile().isDirectory() && !output.getParentFile().mkdirs()) {
                            throw new MojoFailureException("Cannot create folder for " + output);
                        }
                        try (FileOutputStream outputStream = new FileOutputStream(output);){
                            ((OutputStream)outputStream).write(classWriter.toByteArray());
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to upgrade classes", (Exception)e);
            }
        }
    }
}

