/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class TaskSupplement {
    public static final String UNQUALIFIED = null;
    private final ConcurrentMap<Key, Object> supplements = new ConcurrentHashMap<Key, Object>();

    public <T> T require(Class<T> type) {
        return this.require(type, UNQUALIFIED);
    }

    public <T> T require(Class<T> type, String qualifier) {
        return this.probe(type, qualifier).orElseThrow(() -> new IllegalStateException("Could not find supplement of type " + type.getTypeName() + (String)(qualifier != null ? " with qualifier " + qualifier : " without qualifier")));
    }

    public <T> Optional<T> probe(Class<T> type) {
        return this.probe(type, UNQUALIFIED);
    }

    public <T> Optional<T> probe(Class<T> type, String qualifier) {
        return Optional.ofNullable(this.supplements.get(new Key(type, qualifier))).map(type::cast);
    }

    public <T> void register(Class<T> type, T value) {
        this.register(type, UNQUALIFIED, value);
    }

    public <T> void register(Class<T> type, String qualifier, T value) {
        if (this.supplements.putIfAbsent(new Key(type, qualifier), value) != null) {
            throw new IllegalStateException("Supplement for " + type.getTypeName() + " " + (String)(qualifier == null ? "without qualifier" : "with qualifier '" + qualifier + "'") + " already registered");
        }
    }

    public <T> T suggest(Class<T> type, Supplier<? extends T> factory) {
        return this.suggest(type, UNQUALIFIED, factory);
    }

    public <T> T suggest(Class<T> type, String qualifier, Supplier<? extends T> factory) {
        return type.cast(this.supplements.computeIfAbsent(new Key(type, qualifier), ignored -> factory.get()));
    }

    static class Key {
        private final Class<?> type;
        private final String qualifier;

        Key(Class<?> type, String qualifier) {
            this.type = Objects.requireNonNull(type, "Supplement type must not be null");
            this.qualifier = qualifier;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.qualifier != null ? this.qualifier.equals(key.qualifier) : key.qualifier == null;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.type.getTypeName() + (String)(this.qualifier == null ? "" : "/" + this.qualifier);
        }
    }
}

