/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSupplement;

public class Task
implements Comparable<Task> {
    private final long sequence;
    private final String identifier;
    private final String input;

    public Task(long sequence, String identifier) {
        this.sequence = sequence;
        this.identifier = identifier;
        this.input = null;
    }

    public Task(long sequence, String identifier, String input) {
        this.sequence = sequence;
        this.identifier = identifier;
        this.input = input;
    }

    public static BiFunction<Set<Task>, TaskSupplement, Map<Task, TaskDecision>> filterDuplicatedIdentifiers() {
        return Task.filterDuplicatedIdentifiers(TaskResult.FILTER);
    }

    public static BiFunction<Set<Task>, TaskSupplement, Map<Task, TaskDecision>> filterDuplicatedIdentifiers(TaskResult result) {
        return (tasks, supplement) -> {
            Map<String, Long> maxima = tasks.stream().collect(Collectors.toMap(Task::getIdentifier, Task::getSequence, Math::max));
            return tasks.stream().collect(Collectors.toMap(Function.identity(), task -> ((Long)maxima.get(task.getIdentifier())).longValue() == task.getSequence() ? TaskDecision.SUCCESS : new TaskDecision(result, "Identifier is duplicated in batch")));
        };
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<String> getInput() {
        return Optional.ofNullable(this.input);
    }

    @Override
    public int compareTo(Task task) {
        return Long.compare(this.sequence, task.sequence);
    }

    public int hashCode() {
        return (int)(this.sequence ^ this.sequence >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Task)) {
            return false;
        }
        Task task = (Task)object;
        if (this.sequence != task.sequence) {
            return false;
        }
        return this.identifier.equals(task.identifier);
    }

    public String toString() {
        return "task:" + this.identifier + "@" + this.sequence;
    }
}

