/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSupplement;

public class TaskPartialBatch<SUPPLEMENT extends TaskSupplement>
implements BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> {
    private final BiPredicate<Task, SUPPLEMENT> predicate;
    private final BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> delegate;
    private final TaskDecision fallback;

    public TaskPartialBatch(BiPredicate<Task, SUPPLEMENT> predicate, BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> delegate) {
        this(predicate, delegate, TaskDecision.SUCCESS);
    }

    public TaskPartialBatch(BiPredicate<Task, SUPPLEMENT> predicate, BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> delegate, TaskDecision fallback) {
        this.predicate = predicate;
        this.delegate = delegate;
        this.fallback = fallback;
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> ofNoResult(BiPredicate<Task, SUPPLEMENT> predicate, BiConsumer<Set<Task>, SUPPLEMENT> delegate) {
        return TaskPartialBatch.of(predicate, delegate);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> ofNoResult(BiPredicate<Task, SUPPLEMENT> predicate, BiConsumer<Set<Task>, SUPPLEMENT> delegate, TaskDecision fallback) {
        return TaskPartialBatch.of(predicate, delegate, fallback);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> of(BiPredicate<Task, SUPPLEMENT> predicate, BiConsumer<Set<Task>, SUPPLEMENT> delegate) {
        return TaskPartialBatch.of(predicate, delegate, TaskDecision.SUCCESS);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> of(BiPredicate<Task, SUPPLEMENT> predicate, BiConsumer<Set<Task>, SUPPLEMENT> delegate, TaskDecision fallback) {
        return TaskPartialBatch.of(predicate, (Set<Task> tasks, SUPPLEMENT supplement) -> {
            delegate.accept((Set<Task>)tasks, (Object)supplement);
            return tasks.stream().collect(Collectors.toMap(Function.identity(), task -> TaskDecision.SUCCESS));
        }, fallback);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> ofResult(BiPredicate<Task, SUPPLEMENT> predicate, BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> delegate) {
        return TaskPartialBatch.of(predicate, delegate);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> ofResult(BiPredicate<Task, SUPPLEMENT> predicate, BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> delegate, TaskDecision fallback) {
        return TaskPartialBatch.of(predicate, delegate, fallback);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> of(BiPredicate<Task, SUPPLEMENT> predicate, BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> delegate) {
        return TaskPartialBatch.of(predicate, delegate, TaskDecision.SUCCESS);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, CompletionStage<Map<Task, TaskDecision>>> of(BiPredicate<Task, SUPPLEMENT> predicate, BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> delegate, TaskDecision fallback) {
        return new TaskPartialBatch<SUPPLEMENT>(predicate, delegate.andThen(CompletableFuture::completedStage), fallback);
    }

    @Override
    public CompletionStage<Map<Task, TaskDecision>> apply(Set<Task> tasks, SUPPLEMENT supplement) {
        Set active = tasks.stream().filter(task -> this.predicate.test((Task)task, supplement)).collect(Collectors.toCollection(LinkedHashSet::new));
        CompletionStage stage = active.isEmpty() ? CompletableFuture.completedStage(Collections.emptyMap()) : this.delegate.apply(active, supplement);
        return stage.handle((decisions, throwable) -> {
            Map realized = throwable != null ? active.stream().collect(Collectors.toMap(Function.identity(), task -> new TaskDecision((Throwable)throwable))) : decisions;
            return (throwable == null ? Stream.concat(tasks.stream(), decisions.keySet().stream().filter(task -> !tasks.contains(task))) : tasks.stream()).collect(Collectors.toMap(Function.identity(), task -> realized.getOrDefault(task, this.fallback)));
        });
    }
}

