/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskInfo;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskReviver;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSink;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskState;

public interface TaskRepository<TRANSACTION, EXCEPTION extends Exception>
extends TaskSink<TRANSACTION, EXCEPTION>,
TaskSource<TRANSACTION, EXCEPTION>,
TaskReviver<TRANSACTION, EXCEPTION> {
    public static final long INCEPTION = 0L;

    public void register(TRANSACTION var1) throws EXCEPTION;

    public Set<String> owners(TRANSACTION var1, long var2, TimeUnit var4) throws EXCEPTION;

    public void heartbeat(TRANSACTION var1) throws EXCEPTION;

    public void expire(TRANSACTION var1, long var2, TimeUnit var4) throws EXCEPTION;

    public boolean initialize(TRANSACTION var1, String var2) throws EXCEPTION;

    default public void refresh(TRANSACTION transaction) throws EXCEPTION {
    }

    default public void reassign(TRANSACTION transaction, String topic, Task task, TaskResult result) throws EXCEPTION {
        this.reassign(transaction, topic, Collections.singletonMap(task, result));
    }

    public void reassign(TRANSACTION var1, String var2, Map<Task, TaskResult> var3) throws EXCEPTION;

    default public Task recreate(TRANSACTION transaction, String topic, TaskReviver.Revivification revivification, Task task) throws EXCEPTION {
        return this.recreate(transaction, topic, revivification, Collections.singleton(task)).get(task);
    }

    public <TASK extends Task> Map<TASK, Task> recreate(TRANSACTION var1, String var2, TaskReviver.Revivification var3, Set<TASK> var4) throws EXCEPTION;

    default public Optional<TaskInfo> task(TRANSACTION transaction, String topic, long sequence) throws EXCEPTION {
        if (sequence == 0L) {
            return Optional.empty();
        }
        return this.page(transaction, topic, new Listing(), sequence - 1L, 1, Direction.FORWARD).stream().findFirst();
    }

    default public List<TaskInfo> page(TRANSACTION transaction, String topic, long sequence, int size) throws EXCEPTION {
        return this.page(transaction, topic, sequence, size, Direction.FORWARD);
    }

    default public List<TaskInfo> page(TRANSACTION transaction, String topic, long sequence, int size, Direction direction) throws EXCEPTION {
        return this.page(transaction, topic, new Listing(), sequence, size, direction);
    }

    default public List<TaskInfo> page(TRANSACTION transaction, String topic, Listing listing, long sequence, int size) throws EXCEPTION {
        return this.page(transaction, topic, listing, sequence, size, Direction.FORWARD);
    }

    public List<TaskInfo> page(TRANSACTION var1, String var2, Listing var3, long var4, int var6, Direction var7) throws EXCEPTION;

    default public Map<String, Map<TaskState, Long>> count(TRANSACTION transaction, Snapshot snapshot) throws EXCEPTION {
        return this.count(transaction, snapshot, new Counting());
    }

    default public Map<String, Map<TaskState, Long>> count(TRANSACTION transaction, Snapshot snapshot, long from, long to) throws EXCEPTION {
        return this.count(transaction, snapshot, new Counting(), from, to);
    }

    default public Map<String, Map<TaskState, Long>> count(TRANSACTION transaction, Snapshot snapshot, Counting counting) throws EXCEPTION {
        return this.count(transaction, snapshot, counting, 0L, Long.MAX_VALUE);
    }

    public Map<String, Map<TaskState, Long>> count(TRANSACTION var1, Snapshot var2, Counting var3, long var4, long var6) throws EXCEPTION;

    public void purgeAll(TRANSACTION var1, String var2) throws EXCEPTION;

    default public long purge(TRANSACTION transaction, String topic) throws EXCEPTION {
        return this.purge(transaction, topic, 0L, Long.MAX_VALUE);
    }

    public long purge(TRANSACTION var1, String var2, long var3, long var5) throws EXCEPTION;

    default public long purge(TRANSACTION transaction, String topic, TaskState state) throws EXCEPTION {
        return this.purge(transaction, topic, state, 0L, Long.MAX_VALUE);
    }

    public long purge(TRANSACTION var1, String var2, TaskState var3, long var4, long var6) throws EXCEPTION;

    public int purgeOwners(TRANSACTION var1, long var2, TimeUnit var4) throws EXCEPTION;

    default public long resolve(TRANSACTION transaction, LocalDate dateTime, boolean preceding) throws EXCEPTION {
        return this.resolve(transaction, preceding ? dateTime.plusDays(1L).atStartOfDay() : dateTime.atStartOfDay(), preceding);
    }

    public long resolve(TRANSACTION var1, LocalDateTime var2, boolean var3) throws EXCEPTION;

    public static class Listing {
        private final TaskState state;
        private final String identifier;

        public Listing() {
            this.state = null;
            this.identifier = null;
        }

        private Listing(TaskState state, String identifier) {
            this.state = state;
            this.identifier = identifier;
        }

        public Optional<TaskState> getState() {
            return Optional.ofNullable(this.state);
        }

        public Optional<String> getIdentifier() {
            return Optional.ofNullable(this.identifier);
        }

        public Listing withState(TaskState state) {
            return new Listing(state, this.identifier);
        }

        public Listing withIdentifier(String identifier) {
            return new Listing(this.state, identifier);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Listing listing = (Listing)object;
            if (this.state != listing.state) {
                return false;
            }
            return this.identifier != null ? this.identifier.equals(listing.identifier) : listing.identifier == null;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "task:listing[state=" + this.state + ",identifier=" + this.identifier + "]";
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;


        public boolean isLimit(long sequence) {
            return sequence == (this == FORWARD ? 0L : Long.MAX_VALUE);
        }

        public boolean isOutOfBound(long sequence) {
            return sequence < 0L || sequence == (this == BACKWARD ? 0L : Long.MAX_VALUE);
        }
    }

    public static class Counting {
        private final String topic;
        private final TaskState state;
        private final String identifier;

        public Counting() {
            this.topic = null;
            this.state = null;
            this.identifier = null;
        }

        private Counting(String topic, TaskState state, String identifier) {
            this.topic = topic;
            this.state = state;
            this.identifier = identifier;
        }

        public Optional<String> getTopic() {
            return Optional.ofNullable(this.topic);
        }

        public Optional<TaskState> getState() {
            return Optional.ofNullable(this.state);
        }

        public Optional<String> getIdentifier() {
            return Optional.ofNullable(this.identifier);
        }

        public Counting withTopic(String topic) {
            return new Counting(topic, this.state, this.identifier);
        }

        public Counting withState(TaskState state) {
            return new Counting(this.topic, state, this.identifier);
        }

        public Counting withIdentifier(String identifier) {
            return new Counting(this.topic, this.state, identifier);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Counting counting = (Counting)object;
            if (this.topic != null ? !this.topic.equals(counting.topic) : counting.topic != null) {
                return false;
            }
            if (this.state != counting.state) {
                return false;
            }
            return this.identifier != null ? this.identifier.equals(counting.identifier) : counting.identifier == null;
        }

        public int hashCode() {
            int result = this.topic != null ? this.topic.hashCode() : 0;
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "task:counting[topic=" + this.topic + ",state=" + this.state + ",identifier=" + this.identifier + "]";
        }
    }

    public static enum Snapshot {
        RECENT,
        TOTAL;

    }
}

