/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskState;

public enum TaskResult {
    SUCCESS(TaskState.SUCCEEDED),
    SUSPENSION(TaskState.SUSPENDED),
    FILTER(TaskState.FILTERED),
    FAILURE(TaskState.FAILED);

    private static final TaskResult[] VALUES;
    private final TaskState state;

    private TaskResult(TaskState state) {
        this.state = state;
    }

    public static TaskResult ofOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public TaskState toState() {
        return this.state;
    }

    public TaskResult merge(TaskResult other) {
        return this.ordinal() > other.ordinal() ? this : other;
    }

    static {
        VALUES = TaskResult.values();
    }
}

