/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskCreation;

public interface TaskSink<TRANSACTION, EXCEPTION extends Exception> {
    default public Task push(TRANSACTION transaction, String topic, Insertion insertion, String identifier) throws EXCEPTION {
        return this.push(transaction, topic, insertion, new TaskCreation(identifier));
    }

    default public Task push(TRANSACTION transaction, String topic, Insertion insertion, TaskCreation creation) throws EXCEPTION {
        return this.push(transaction, topic, insertion, Collections.singletonList(creation)).get(0);
    }

    default public List<Task> push(TRANSACTION transaction, String topic, Insertion insertion, String ... identifiers) throws EXCEPTION {
        return this.push(transaction, topic, insertion, Arrays.stream(identifiers).map(TaskCreation::new).collect(Collectors.toList()));
    }

    default public List<Task> push(TRANSACTION transaction, String topic, Insertion insertion, Map<String, String> creations) throws EXCEPTION {
        return this.push(transaction, topic, insertion, creations.entrySet().stream().map(entry -> new TaskCreation((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
    }

    default public List<Task> push(TRANSACTION transaction, String topic, Insertion insertion, TaskCreation ... creations) throws EXCEPTION {
        return this.push(transaction, topic, insertion, Arrays.asList(creations));
    }

    public List<Task> push(TRANSACTION var1, String var2, Insertion var3, Collection<TaskCreation> var4) throws EXCEPTION;

    public static enum Insertion {
        APPEND,
        REPLACE;

    }
}

