/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;

public interface TaskSource<TRANSACTION, EXCEPTION extends Exception> {
    default public Optional<Task> poll(TRANSACTION transaction, String topic) throws EXCEPTION {
        return this.poll(transaction, topic, Order.FIRST_IN_FIRST_OUT);
    }

    default public Optional<Task> poll(TRANSACTION transaction, String topic, Order order) throws EXCEPTION {
        return this.poll(transaction, topic, order, 1).stream().findFirst();
    }

    default public Set<Task> poll(TRANSACTION transaction, String topic, int size) throws EXCEPTION {
        return this.poll(transaction, topic, Order.FIRST_IN_FIRST_OUT, size);
    }

    public Set<Task> poll(TRANSACTION var1, String var2, Order var3, int var4) throws EXCEPTION;

    default public void complete(TRANSACTION transaction, String topic, Task task, TaskDecision decision) throws EXCEPTION {
        this.complete(transaction, topic, Collections.singletonMap(task, decision));
    }

    public void complete(TRANSACTION var1, String var2, Map<Task, TaskDecision> var3) throws EXCEPTION;

    public static enum Order {
        FIRST_IN_FIRST_OUT,
        LAST_IN_FIRST_OUT;

    }
}

