/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskCreation;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskJuncture;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSink;

public interface TaskConsumer {
    default public void pushByTask(Task task, String topic, TaskSink.Insertion insertion) {
        this.pushByTask(Collections.singleton(task), topic, insertion);
    }

    default public void pushByTask(Task task, String topic, TaskSink.Insertion insertion, TaskCreation ... creations) {
        this.pushByTask(task, topic, insertion, Arrays.asList(creations));
    }

    default public void pushByTask(Task task, String topic, TaskSink.Insertion insertion, Collection<TaskCreation> creations) {
        this.pushByTask(Collections.singleton(task), topic, insertion, (Task ignored) -> creations);
    }

    default public void pushByTask(Set<Task> tasks, String topic, TaskSink.Insertion insertion) {
        this.pushByTask(tasks, topic, insertion, (Task task) -> Collections.singleton(new TaskCreation(task.getIdentifier())));
    }

    public void pushByTask(Set<Task> var1, String var2, TaskSink.Insertion var3, Function<Task, Collection<TaskCreation>> var4);

    default public void junctionByTask(Task task, Set<String> identifiers, String topic, TaskJuncture.Junction junction) {
        this.junctionByTask(Map.of(task, identifiers), topic, junction);
    }

    public void junctionByTask(Map<Task, Set<String>> var1, String var2, TaskJuncture.Junction var3);
}

