/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Optional;

public class TaskCreation {
    private final String identifier;
    private final String input;
    private final String reference;
    private final boolean suspended;

    public TaskCreation(String identifier) {
        this.identifier = identifier;
        this.input = null;
        this.reference = null;
        this.suspended = false;
    }

    public TaskCreation(String identifier, String input) {
        this.identifier = identifier;
        this.input = input == null || input.isBlank() ? null : input;
        this.reference = null;
        this.suspended = false;
    }

    private TaskCreation(String identifier, String input, String reference, boolean suspended) {
        this.identifier = identifier;
        this.input = input;
        this.reference = reference;
        this.suspended = suspended;
    }

    public TaskCreation withReference(String reference) {
        return new TaskCreation(this.identifier, this.input, reference == null || reference.isBlank() ? null : reference, this.suspended);
    }

    public TaskCreation withSuspension(boolean suspended) {
        return new TaskCreation(this.identifier, this.input, this.reference, suspended);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<String> getInput() {
        return Optional.ofNullable(this.input);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TaskCreation that = (TaskCreation)object;
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.input != null ? this.input.equals(that.input) : that.input == null;
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "task:creation:" + this.identifier + (String)(this.input != null ? "/" + this.input.length() + "c" : "");
    }
}

