/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;

public class TaskSupplement {
    public static final String UNQUALIFIED = null;
    public static final Task GLOBAL = null;
    private final ConcurrentMap<Key, Object> supplements = new ConcurrentHashMap<Key, Object>();

    public <T> T require(Class<T> type) {
        return this.require(type, UNQUALIFIED);
    }

    public <T> T require(Class<T> type, Task task) {
        return this.require(type, task, UNQUALIFIED);
    }

    public <T> T require(Class<T> type, String qualifier) {
        return this.require(type, GLOBAL, qualifier);
    }

    public <T> T require(Class<T> type, Task task, String qualifier) {
        return this.probe(type, task, qualifier).orElseThrow(() -> new IllegalStateException("Could not find supplement of type " + type.getTypeName() + (String)(qualifier != null ? " with qualifier " + qualifier : " without qualifier") + (String)(task == null ? "" : " for task " + String.valueOf(task))));
    }

    public <T> T require(Token<T> token) {
        return this.require(token, UNQUALIFIED);
    }

    public <T> T require(Token<T> token, Task task) {
        return this.require(token, task, UNQUALIFIED);
    }

    public <T> T require(Token<T> token, String qualifier) {
        return this.require(token, GLOBAL, qualifier);
    }

    public <T> T require(Token<T> token, Task task, String qualifier) {
        return this.probe(token, task, qualifier).orElseThrow(() -> new IllegalStateException("Could not find supplement of type " + token.getType().getTypeName() + (String)(qualifier != null ? " with qualifier " + qualifier : " without qualifier") + (String)(task == null ? "" : " for task " + String.valueOf(task))));
    }

    public <T> Optional<T> probe(Class<T> type) {
        return this.probe(type, UNQUALIFIED);
    }

    public <T> Optional<T> probe(Class<T> type, Task task) {
        return this.probe(type, task, UNQUALIFIED);
    }

    public <T> Optional<T> probe(Class<T> type, String qualifier) {
        return this.probe(type, GLOBAL, qualifier);
    }

    public <T> Optional<T> probe(Class<T> type, Task task, String qualifier) {
        return Optional.ofNullable(this.supplements.get(new Key(type, task, qualifier))).map(type::cast);
    }

    public <T> Optional<T> probe(Token<T> token) {
        return this.probe(token, UNQUALIFIED);
    }

    public <T> Optional<T> probe(Token<T> token, Task task) {
        return this.probe(token, task, UNQUALIFIED);
    }

    public <T> Optional<T> probe(Token<T> token, String qualifier) {
        return this.probe(token, GLOBAL, qualifier);
    }

    public <T> Optional<T> probe(Token<T> token, Task task, String qualifier) {
        return Optional.ofNullable(this.supplements.get(new Key(token.getType(), task, qualifier))).map(token::cast);
    }

    public <T> void register(Class<T> type, T value) {
        this.register(type, UNQUALIFIED, value);
    }

    public <T> void register(Class<T> type, Task task, T value) {
        this.register(type, task, UNQUALIFIED, value);
    }

    public <T> void register(Class<T> type, String qualifier, T value) {
        this.register(type, GLOBAL, qualifier, value);
    }

    public <T> void register(Class<T> type, Task task, String qualifier, T value) {
        if (this.supplements.putIfAbsent(new Key(type, task, qualifier), value) != null) {
            throw new IllegalStateException("Supplement for " + type.getTypeName() + " " + (String)(qualifier == null ? "without qualifier" : "with qualifier '" + qualifier + "'") + " already registered" + (String)(task == null ? "" : " for task " + String.valueOf(task)));
        }
    }

    public <T> void register(Token<T> token, T value) {
        this.register(token, UNQUALIFIED, value);
    }

    public <T> void register(Token<T> token, Task task, T value) {
        this.register(token, task, UNQUALIFIED, value);
    }

    public <T> void register(Token<T> token, String qualifier, T value) {
        this.register(token, GLOBAL, qualifier, value);
    }

    public <T> void register(Token<T> token, Task task, String qualifier, T value) {
        if (this.supplements.putIfAbsent(new Key(token.getType(), task, qualifier), value) != null) {
            throw new IllegalStateException("Supplement for " + token.getType().getTypeName() + " " + (String)(qualifier == null ? "without qualifier" : "with qualifier '" + qualifier + "'") + " already registered" + (String)(task == null ? "" : " for task " + String.valueOf(task)));
        }
    }

    public <T> T suggest(Class<T> type, Supplier<? extends T> factory) {
        return this.suggest(type, UNQUALIFIED, factory);
    }

    public <T> T suggest(Class<T> type, Task task, Supplier<? extends T> factory) {
        return this.suggest(type, task, UNQUALIFIED, factory);
    }

    public <T> T suggest(Class<T> type, String qualifier, Supplier<? extends T> factory) {
        return this.suggest(type, GLOBAL, qualifier, factory);
    }

    public <T> T suggest(Class<T> type, Task task, String qualifier, Supplier<? extends T> factory) {
        return type.cast(this.supplements.computeIfAbsent(new Key(type, task, qualifier), ignored -> factory.get()));
    }

    public <T> T suggest(Token<T> token, Supplier<? extends T> factory) {
        return this.suggest(token, UNQUALIFIED, factory);
    }

    public <T> T suggest(Token<T> token, Task task, Supplier<? extends T> factory) {
        return this.suggest(token, task, UNQUALIFIED, factory);
    }

    public <T> T suggest(Token<T> token, String qualifier, Supplier<? extends T> factory) {
        return this.suggest(token, GLOBAL, qualifier, factory);
    }

    public <T> T suggest(Token<T> token, Task task, String qualifier, Supplier<? extends T> factory) {
        return (T)token.cast(this.supplements.computeIfAbsent(new Key(token.getType(), task, qualifier), ignored -> factory.get()));
    }

    public static abstract class Token<T> {
        private final Type type;

        protected Token() {
            if (this.getClass().getSuperclass() != Token.class) {
                throw new IllegalStateException("Expected a direct subclass of " + Token.class.getTypeName());
            }
            Type type = this.getClass().getGenericSuperclass();
            if (!(type instanceof ParameterizedType)) {
                throw new IllegalStateException("Expected subclass of " + Token.class.getTypeName() + " to be parameterized");
            }
            this.type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }

        Type getType() {
            return this.type;
        }

        <S> S cast(Object value) {
            return (S)value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Token token = (Token)object;
            return this.type.equals(token.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type.getTypeName();
        }
    }

    static class Key {
        private final Type type;
        private final Task task;
        private final String qualifier;

        Key(Type type, Task task, String qualifier) {
            this.type = Objects.requireNonNull(type, "Supplement type must not be null");
            this.task = task;
            this.qualifier = qualifier;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            if (!this.type.equals(key.type)) {
                return false;
            }
            if (!Objects.equals(this.task, key.task)) {
                return false;
            }
            return Objects.equals(this.qualifier, key.qualifier);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.task != null ? this.task.hashCode() : 0);
            result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.type.getTypeName() + (String)(this.task == null ? "" : "@" + String.valueOf(this.task)) + (String)(this.qualifier == null ? "" : "/" + this.qualifier);
        }
    }
}

