/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;

public class TaskDecision {
    public static final TaskDecision FAILURE = new TaskDecision(TaskResult.FAILURE);
    public static final TaskDecision SUSPENSION = new TaskDecision(TaskResult.SUSPENSION);
    public static final TaskDecision FILTER = new TaskDecision(TaskResult.FILTER);
    public static final TaskDecision SUCCESS = new TaskDecision(TaskResult.SUCCESS);
    private final TaskResult result;
    private final Throwable throwable;
    private final boolean continued;

    private TaskDecision(TaskResult result) {
        this.result = result;
        this.throwable = null;
        this.continued = result == TaskResult.SUCCESS;
    }

    public TaskDecision(String message) {
        this.result = TaskResult.SUCCESS;
        this.throwable = message == null ? null : new MessageCarryingThrowable(message);
        this.continued = true;
    }

    public TaskDecision(Throwable throwable) {
        this.result = TaskResult.FAILURE;
        this.throwable = throwable;
        this.continued = false;
    }

    public TaskDecision(TaskResult result, String message) {
        this.result = result;
        this.throwable = message == null ? null : new MessageCarryingThrowable(message);
        this.continued = result == TaskResult.SUCCESS;
    }

    public TaskDecision(TaskResult result, Throwable throwable) {
        this.result = result;
        this.throwable = throwable;
        this.continued = result == TaskResult.SUCCESS;
    }

    TaskDecision(TaskResult result, Throwable throwable, boolean continued) {
        this.result = result;
        this.throwable = throwable;
        this.continued = continued;
    }

    public TaskResult getResult() {
        return this.result;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public boolean isContinued() {
        return this.continued;
    }

    public TaskDecision withContinuation(boolean continued) {
        return this.continued == continued ? this : new TaskDecision(this.result, this.throwable, continued);
    }

    public TaskDecision merge(TaskDecision other) {
        if (this.result == other.result && this.throwable == other.throwable) {
            return this;
        }
        return new TaskDecision(this.result.merge(other.result), this.throwable == null || this.throwable == other.throwable ? other.throwable : (other.throwable == null ? this.throwable : new MergedThrowable(this.throwable, other.throwable)), this.continued && other.continued);
    }

    public TaskDecision include(String message) {
        return message == null ? this : this.include(new MessageCarryingThrowable(message));
    }

    public TaskDecision include(Throwable throwable) {
        return new TaskDecision(this.result, this.throwable == null || this.throwable == throwable ? throwable : (throwable == null ? this.throwable : new MergedThrowable(this.throwable, throwable)), this.continued);
    }

    public Optional<String> toMessage() {
        if (this.throwable == null) {
            return Optional.empty();
        }
        if (this.throwable instanceof MessageCarryingThrowable) {
            return Optional.of(this.throwable.getMessage());
        }
        StringWriter writer = new StringWriter();
        this.throwable.printStackTrace(new PrintWriter((Writer)writer, true));
        return Optional.of(writer.toString());
    }

    public boolean isSameAs(TaskDecision decision) {
        if (this.result != decision.result) {
            return false;
        }
        if (this.throwable == null) {
            return decision.throwable == null;
        }
        if (this.throwable instanceof MessageCarryingThrowable) {
            return decision.throwable instanceof MessageCarryingThrowable && this.throwable.getMessage().equals(decision.throwable.getMessage());
        }
        return this.throwable.equals(decision.throwable);
    }

    public static Map<Task, TaskDecision> combine(Map<Task, TaskDecision> left, Map<Task, TaskDecision> right) {
        return Stream.concat(left.entrySet().stream(), right.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<Task, TaskDecision> merge(Map<Task, TaskDecision> left, Map<Task, TaskDecision> right) {
        return left.keySet().stream().filter(right::containsKey).collect(Collectors.toMap(Function.identity(), task -> ((TaskDecision)left.get(task)).merge((TaskDecision)right.get(task))));
    }

    public int hashCode() {
        return this.result.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TaskDecision that = (TaskDecision)object;
        return this.result == that.result;
    }

    public String toString() {
        return "task:decision:" + String.valueOf((Object)this.result) + (String)(this.throwable != null ? "/" + this.throwable.getClass().getTypeName() : "");
    }

    static class MessageCarryingThrowable
    extends Throwable {
        MessageCarryingThrowable(String message) {
            super(message, null, false, false);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    static class MergedThrowable
    extends Throwable {
        MergedThrowable(Throwable left, Throwable right) {
            super("Multiple stacks collected", null, true, false);
            if (left instanceof MergedThrowable) {
                Arrays.stream(left.getSuppressed()).forEach(this::addSuppressed);
            } else {
                this.addSuppressed(left);
            }
            if (right instanceof MergedThrowable) {
                Arrays.stream(right.getSuppressed()).forEach(this::addSuppressed);
            } else {
                this.addSuppressed(right);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("Captured ").append(this.getSuppressed().length).append(" throwables:");
            Arrays.stream(this.getSuppressed()).forEach(throwable -> sb.append("\n").append(throwable.getClass().getTypeName()).append(": ").append(throwable.getMessage()));
            return sb.toString();
        }
    }
}

