/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSupplement;

public class TaskDuplicationFilter<CRITERIA, SUPPLEMENT extends TaskSupplement>
implements BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> {
    private final BiFunction<Task, ? super SUPPLEMENT, CRITERIA> identification;
    private final Selector<CRITERIA, ? super SUPPLEMENT> selector;
    private final TaskResult ifFiltered;

    public TaskDuplicationFilter(BiFunction<Task, ? super SUPPLEMENT, CRITERIA> identification, Selector<CRITERIA, ? super SUPPLEMENT> selector, TaskResult ifFiltered) {
        this.identification = identification;
        this.selector = selector;
        this.ifFiltered = ifFiltered;
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> all() {
        return TaskDuplicationFilter.all(TaskResult.FAILURE);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> all(TaskResult ifFiltered) {
        return TaskDuplicationFilter.all((task, supplement) -> task.getIdentifier(), ifFiltered);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> all(BiFunction<Task, ? super SUPPLEMENT, ?> identification) {
        return TaskDuplicationFilter.all(identification, TaskResult.FAILURE);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> all(BiFunction<Task, ? super SUPPLEMENT, ?> identification, TaskResult ifFiltered) {
        return new TaskDuplicationFilter<Object, TaskSupplement>(identification, (tasks, supplement, criteria) -> List.of(), ifFiltered);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> outdated() {
        return TaskDuplicationFilter.outdated(TaskResult.FILTER);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> outdated(TaskResult ifFiltered) {
        return TaskDuplicationFilter.outdated((task, supplement) -> task.getIdentifier(), ifFiltered);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> outdated(BiFunction<Task, ? super SUPPLEMENT, ?> identification) {
        return TaskDuplicationFilter.outdated(identification, TaskResult.FILTER);
    }

    public static <SUPPLEMENT extends TaskSupplement> BiFunction<Set<Task>, SUPPLEMENT, Map<Task, TaskDecision>> outdated(BiFunction<Task, ? super SUPPLEMENT, ?> identification, TaskResult ifFiltered) {
        return new TaskDuplicationFilter<Object, TaskSupplement>(identification, (tasks, supplement, criteria) -> List.of((Task)tasks.stream().max(Comparator.naturalOrder()).orElseThrow()), ifFiltered);
    }

    @Override
    public Map<Task, TaskDecision> apply(Set<Task> tasks, SUPPLEMENT supplement) {
        HashMap<Task, TaskDecision> decisions = new HashMap<Task, TaskDecision>();
        tasks.stream().collect(Collectors.groupingBy(task -> this.identification.apply((Task)task, supplement), Collectors.toCollection(TreeSet::new))).forEach((criteria, duplicates) -> {
            if (duplicates.size() == 1) {
                duplicates.forEach(task -> decisions.put((Task)task, TaskDecision.SUCCESS));
            } else {
                TreeSet<Task> selected = new TreeSet<Task>(this.selector.apply((Set<Task>)duplicates, (TaskSupplement)supplement, criteria));
                duplicates.forEach(task -> decisions.put((Task)task, selected.contains(task) ? TaskDecision.SUCCESS : new TaskDecision(this.ifFiltered, "Found duplicated among " + String.valueOf(duplicates) + " with selected: " + String.valueOf(selected))));
            }
        });
        return decisions;
    }

    @FunctionalInterface
    public static interface Selector<CRITERIA, SUPPLEMENT extends TaskSupplement> {
        public Collection<Task> apply(Set<Task> var1, SUPPLEMENT var2, CRITERIA var3);
    }
}

