/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskConsumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskCreation;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSink;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSupplement;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskContext;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskContextCompletion;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskDispatcher;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;

public class TaskConsumerContext<TRANSACTION, EXCEPTION extends Exception>
implements TaskConsumer,
TaskContext<TRANSACTION, EXCEPTION> {
    private final Set<Task> tasks;
    private final TaskDispatcher<TRANSACTION, EXCEPTION> dispatcher;
    private final TaskSink<TRANSACTION, EXCEPTION> taskSink;
    private final Function<String, Optional<TaskProcessor>> processors;
    private final Map<String, List<Definition>> topics = new ConcurrentHashMap<String, List<Definition>>();

    public TaskConsumerContext(Set<Task> tasks, TaskDispatcher<TRANSACTION, EXCEPTION> dispatcher, TaskSink<TRANSACTION, EXCEPTION> taskSink, Function<String, Optional<TaskProcessor>> processors) {
        this.tasks = tasks;
        this.dispatcher = dispatcher;
        this.taskSink = taskSink;
        this.processors = processors;
    }

    public void pushByTask(Set<Task> tasks, String topic, TaskSink.Insertion insertion, Function<Task, Collection<TaskCreation>> resolver) {
        if (!this.tasks.containsAll(tasks)) {
            throw new IllegalArgumentException("Cannot write tasks for unknown tasks: " + tasks.stream().filter(task -> !this.tasks.contains(task)).collect(Collectors.toList()));
        }
        this.topics.computeIfAbsent(topic, ignored -> new CopyOnWriteArrayList()).add(new Definition(tasks, insertion, resolver));
    }

    @Override
    public CompletionStage<TaskContextCompletion<TRANSACTION, EXCEPTION>> apply(Map<Task, TaskDecision> decisions, Executor executor, TaskSupplement supplement) {
        CompletableFuture<TaskContextCompletion<TRANSACTION, EXCEPTION>> future = new CompletableFuture<TaskContextCompletion<TRANSACTION, EXCEPTION>>();
        if (this.topics.isEmpty()) {
            future.complete(transaction -> decisions);
        } else {
            executor.execute(() -> {
                try {
                    Set succeeded = decisions.entrySet().stream().filter(entry -> ((TaskDecision)entry.getValue()).getResult() == TaskResult.SUCCESS).map(Map.Entry::getKey).collect(Collectors.toSet());
                    for (Map.Entry<String, List<Definition>> entry2 : this.topics.entrySet()) {
                        List resolved = entry2.getValue().stream().flatMap(definition -> definition.resolve(succeeded).stream()).collect(Collectors.toList());
                        if (resolved.isEmpty()) continue;
                        this.dispatcher.accept(transaction -> {
                            Iterator it = resolved.iterator();
                            Resolved current = (Resolved)it.next();
                            TaskSink.Insertion insertion = current.getInsertion();
                            ArrayList<TaskCreation> creations = new ArrayList<TaskCreation>(resolved.size());
                            creations.add(current.getCreation());
                            while (it.hasNext()) {
                                current = (Resolved)it.next();
                                if (current.getInsertion() != insertion) {
                                    this.taskSink.push(transaction, (String)entry2.getKey(), insertion, creations);
                                    insertion = current.getInsertion();
                                    creations.clear();
                                }
                                creations.add(current.getCreation());
                            }
                            this.taskSink.push(transaction, (String)entry2.getKey(), insertion, creations);
                        });
                        this.processors.apply(entry2.getKey()).ifPresent(TaskProcessor::resume);
                    }
                    future.complete(transaction -> decisions);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        return future;
    }

    static class Resolved {
        private final Task task;
        private final TaskSink.Insertion insertion;
        private final TaskCreation creation;

        Resolved(Task task, TaskSink.Insertion insertion, TaskCreation creation) {
            this.task = task;
            this.creation = creation;
            this.insertion = insertion;
        }

        Task getTask() {
            return this.task;
        }

        TaskSink.Insertion getInsertion() {
            return this.insertion;
        }

        TaskCreation getCreation() {
            return this.creation;
        }
    }

    static class Definition {
        private final Set<Task> tasks;
        private final TaskSink.Insertion insertion;
        private final Function<Task, Collection<TaskCreation>> resolver;

        Definition(Set<Task> tasks, TaskSink.Insertion insertion, Function<Task, Collection<TaskCreation>> resolver) {
            this.tasks = tasks;
            this.insertion = insertion;
            this.resolver = resolver;
        }

        public List<Resolved> resolve(Set<Task> succeeded) {
            return this.tasks.stream().filter(succeeded::contains).flatMap(task -> this.resolver.apply((Task)task).stream().map(creation -> new Resolved((Task)task, this.insertion, (TaskCreation)creation))).collect(Collectors.toList());
        }
    }
}

