/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResultException;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskCallback;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskContext;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskContextFactory;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskHandler;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskHandlerShutdownException;

public class CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION extends Exception, IDENTITY, CONTEXT extends TaskContext<TRANSACTION, EXCEPTION>>
implements Function<String, TaskHandler<TRANSACTION, EXCEPTION>> {
    private final Executor executor;
    private final boolean failPendingOnClose;
    private final int concurrency;
    private final TaskContextFactory<TRANSACTION, EXCEPTION, CONTEXT> contextFactory;
    private final Function<String, BiFunction<IDENTITY, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>>> decoratorFactory;
    private final Map<IDENTITY, Registration<CONTEXT, IDENTITY>> registrations;

    public CompositeTaskHandlerFactory(Executor executor, boolean failPendingOnClose, int concurrency, TaskContextFactory<TRANSACTION, EXCEPTION, CONTEXT> contextFactory) {
        this.executor = executor;
        this.failPendingOnClose = failPendingOnClose;
        this.concurrency = concurrency;
        this.contextFactory = contextFactory;
        this.decoratorFactory = topic -> (identity, step) -> step;
        this.registrations = Collections.emptyMap();
    }

    public CompositeTaskHandlerFactory(Executor executor, boolean failPendingOnClose, int concurrency, TaskContextFactory<TRANSACTION, EXCEPTION, CONTEXT> contextFactory, Function<String, BiFunction<IDENTITY, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>>> decoratorFactory) {
        this.executor = executor;
        this.failPendingOnClose = failPendingOnClose;
        this.concurrency = concurrency;
        this.contextFactory = contextFactory;
        this.decoratorFactory = decoratorFactory;
        this.registrations = Collections.emptyMap();
    }

    private CompositeTaskHandlerFactory(Executor executor, boolean failPendingOnClose, int concurrency, TaskContextFactory<TRANSACTION, EXCEPTION, CONTEXT> contextFactory, Function<String, BiFunction<IDENTITY, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>>> decoratorFactory, Map<IDENTITY, Registration<CONTEXT, IDENTITY>> registrations) {
        this.executor = executor;
        this.failPendingOnClose = failPendingOnClose;
        this.concurrency = concurrency;
        this.contextFactory = contextFactory;
        this.decoratorFactory = decoratorFactory;
        this.registrations = registrations;
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEach(IDENTITY identity, BiConsumer<Task, ? super CONTEXT> step, IDENTITY ... dependencies) {
        return this.withEachNoResult(identity, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEach(IDENTITY identity, Mode mode, BiConsumer<Task, ? super CONTEXT> step, IDENTITY ... dependencies) {
        return this.withEachNoResult(identity, mode, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEach(IDENTITY identity, BiFunction<Task, ? super CONTEXT, TaskDecision> step, IDENTITY ... dependencies) {
        return this.withEachResult(identity, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEach(IDENTITY identity, Mode mode, BiFunction<Task, ? super CONTEXT, TaskDecision> step, IDENTITY ... dependencies) {
        return this.withEachResult(identity, mode, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> with(IDENTITY identity, BiConsumer<Set<Task>, ? super CONTEXT> step, IDENTITY ... dependencies) {
        return this.withNoResult(identity, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> with(IDENTITY identity, BiFunction<Set<Task>, ? super CONTEXT, Map<Task, TaskDecision>> step, IDENTITY ... dependencies) {
        return this.withResult(identity, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEachNoResult(IDENTITY identity, BiConsumer<Task, ? super CONTEXT> step, IDENTITY ... dependencies) {
        return this.withEachNoResult(identity, Mode.PARALLEL, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEachNoResult(IDENTITY identity, Mode mode, BiConsumer<Task, ? super CONTEXT> step, IDENTITY ... dependencies) {
        return this.withEachResult(identity, mode, (task, context) -> {
            step.accept((Task)task, (Object)context);
            return TaskDecision.SUCCESS;
        }, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEachResult(IDENTITY identity, BiFunction<Task, ? super CONTEXT, TaskDecision> step, IDENTITY ... dependencies) {
        return this.withEachResult(identity, Mode.PARALLEL, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEachResult(IDENTITY identity, Mode mode, BiFunction<Task, ? super CONTEXT, TaskDecision> step, IDENTITY ... dependencies) {
        return this.withEachAsync(identity, mode, (task, context) -> CompletableFuture.completedStage((TaskDecision)step.apply((Task)task, (Object)context)), dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withNoResult(IDENTITY identity, BiConsumer<Set<Task>, ? super CONTEXT> step, IDENTITY ... dependencies) {
        return this.withResult(identity, (tasks, context) -> {
            step.accept((Set<Task>)tasks, (Object)context);
            return tasks.stream().collect(Collectors.toMap(Function.identity(), task -> TaskDecision.SUCCESS));
        }, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withResult(IDENTITY identity, BiFunction<Set<Task>, ? super CONTEXT, Map<Task, TaskDecision>> step, IDENTITY ... dependencies) {
        return this.withAsync(identity, (tasks, context) -> CompletableFuture.completedStage((Map)step.apply((Set<Task>)tasks, (Object)context)), dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEachAsync(IDENTITY identity, BiFunction<Task, ? super CONTEXT, CompletionStage<TaskDecision>> step, IDENTITY ... dependencies) {
        return this.withEachAsync(identity, Mode.PARALLEL, step, dependencies);
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withEachAsync(IDENTITY identity, Mode mode, BiFunction<Task, ? super CONTEXT, CompletionStage<TaskDecision>> step, IDENTITY ... dependencies) {
        return this.withStep(identity, (tasks, context) -> mode.stream((Collection<Task>)tasks).map(task -> {
            try {
                return ((CompletionStage)step.apply((Task)task, (CONTEXT)context)).handleAsync((result, throwable) -> {
                    TaskDecision decision = throwable == null ? result : (throwable instanceof TaskResultException ? ((TaskResultException)((Object)((Object)((Object)throwable)))).toDecision() : new TaskDecision(throwable));
                    return Collections.singletonMap(task, decision);
                }, this.executor);
            }
            catch (TaskResultException exception) {
                return CompletableFuture.completedStage(Collections.singletonMap(task, new TaskDecision(exception.getResult(), (Throwable)exception)));
            }
            catch (Throwable throwable2) {
                return CompletableFuture.completedStage(Collections.singletonMap(task, new TaskDecision(throwable2)));
            }
        }).reduce(CompletableFuture.completedStage(Collections.emptyMap()), (left, right) -> left.thenCombineAsync(right, TaskDecision::combine, this.executor)), Arrays.asList(dependencies));
    }

    @SafeVarargs
    public final CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withAsync(IDENTITY identity, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>> step, IDENTITY ... dependencies) {
        return this.withStep(identity, (tasks, context) -> {
            try {
                return ((CompletionStage)step.apply((Set<Task>)tasks, (CONTEXT)context)).handleAsync((decisions, throwable) -> {
                    if (throwable == null) {
                        return decisions;
                    }
                    if (throwable instanceof TaskResultException) {
                        return tasks.stream().collect(Collectors.toMap(Function.identity(), task -> ((TaskResultException)((Object)((Object)throwable))).toDecision()));
                    }
                    return tasks.stream().collect(Collectors.toMap(Function.identity(), task -> new TaskDecision(throwable)));
                }, this.executor);
            }
            catch (TaskResultException exception) {
                return CompletableFuture.completedStage(tasks.stream().collect(Collectors.toMap(Function.identity(), task -> new TaskDecision(exception.getResult(), (Throwable)exception))));
            }
            catch (Throwable throwable2) {
                return CompletableFuture.completedStage(tasks.stream().collect(Collectors.toMap(Function.identity(), task -> new TaskDecision(throwable2))));
            }
        }, Arrays.asList(dependencies));
    }

    private CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT> withStep(IDENTITY identity, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>> step, List<IDENTITY> dependencies) {
        if (!this.registrations.keySet().containsAll(dependencies)) {
            throw new IllegalArgumentException("Unknown dependencies: " + dependencies.stream().filter(dependency -> !this.registrations.containsKey(dependency)).distinct().collect(Collectors.toList()));
        }
        LinkedHashMap<IDENTITY, Registration<CONTEXT, IDENTITY>> registrations = new LinkedHashMap<IDENTITY, Registration<CONTEXT, IDENTITY>>(this.registrations);
        if (registrations.putIfAbsent(identity, new Registration<CONTEXT, IDENTITY>(step, new HashSet<IDENTITY>(dependencies))) != null) {
            throw new IllegalArgumentException("Step already registered: " + identity);
        }
        return new CompositeTaskHandlerFactory<TRANSACTION, EXCEPTION, IDENTITY, CONTEXT>(this.executor, this.failPendingOnClose, this.concurrency, this.contextFactory, this.decoratorFactory, registrations);
    }

    @Override
    public TaskHandler<TRANSACTION, EXCEPTION> apply(final String topic) {
        final BiFunction<IDENTITY, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>, BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>>> decorator = this.decoratorFactory.apply(topic);
        final ArrayBlockingQueue queue = this.concurrency == 0 ? null : new ArrayBlockingQueue(this.concurrency);
        return new TaskHandler<TRANSACTION, EXCEPTION>(){

            @Override
            public void accept(Set<Task> tasks, TaskCallback<TRANSACTION, EXCEPTION> callback, Consumer<Throwable> onFailure) throws Exception {
                Unit unit;
                CompletionStage<Object> result;
                block12: {
                    Object context = CompositeTaskHandlerFactory.this.contextFactory.apply(topic, tasks);
                    CompletionStage initial = CompletableFuture.completedStage(tasks.stream().collect(Collectors.toMap(Function.identity(), task -> TaskDecision.SUCCESS)));
                    HashMap dispatched = new HashMap();
                    HashSet latest = new HashSet();
                    while (!dispatched.keySet().containsAll(CompositeTaskHandlerFactory.this.registrations.keySet())) {
                        CompositeTaskHandlerFactory.this.registrations.entrySet().stream().filter(entry -> !dispatched.containsKey(entry.getKey())).filter(entry -> dispatched.keySet().containsAll(((Registration)entry.getValue()).getDependencies())).forEach(registration -> {
                            CompletionStage<Map> future = initial;
                            for (Object dependency : ((Registration)registration.getValue()).getDependencies()) {
                                future = future.thenCombineAsync((CompletionStage)dispatched.get(dependency), TaskDecision::merge, CompositeTaskHandlerFactory.this.executor);
                                latest.remove(dependency);
                            }
                            dispatched.put(registration.getKey(), future.thenComposeAsync(decisions -> {
                                Set active = decisions.entrySet().stream().filter(entry -> ((TaskDecision)entry.getValue()).isContinued()).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
                                if (active.isEmpty()) {
                                    return CompletableFuture.completedStage(decisions);
                                }
                                return ((CompletionStage)((BiFunction)decorator.apply(registration.getKey(), ((Registration)registration.getValue()).getStep())).apply(Collections.unmodifiableSet(active), context)).thenApplyAsync(additional -> Stream.concat(decisions.entrySet().stream().filter(entry -> !active.contains(entry.getKey())), additional.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), CompositeTaskHandlerFactory.this.executor);
                            }, CompositeTaskHandlerFactory.this.executor));
                            latest.add(registration.getKey());
                        });
                    }
                    result = latest.stream().map(dispatched::get).reduce(initial, (left, right) -> left.thenCombineAsync(right, TaskDecision::merge, CompositeTaskHandlerFactory.this.executor)).thenComposeAsync(decisions -> {
                        try {
                            return context.apply(Collections.unmodifiableMap(decisions), CompositeTaskHandlerFactory.this.executor).thenApplyAsync(completion -> transaction -> Stream.concat(decisions.entrySet().stream(), completion.complete(transaction).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, TaskDecision::merge)), CompositeTaskHandlerFactory.this.executor);
                        }
                        catch (Throwable throwable) {
                            return CompletableFuture.failedStage(throwable);
                        }
                    }, CompositeTaskHandlerFactory.this.executor).thenComposeAsync(completion -> {
                        try {
                            callback.accept(completion.toCompletion());
                            return CompletableFuture.completedStage(null);
                        }
                        catch (Throwable throwable) {
                            return CompletableFuture.failedStage(throwable);
                        }
                    }, CompositeTaskHandlerFactory.this.executor).exceptionally(throwable -> {
                        try {
                            onFailure.accept((Throwable)throwable);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        return null;
                    });
                    unit = new Unit(onFailure, new CountDownLatch(1));
                    try {
                        if (queue == null) {
                            try {
                                result.toCompletableFuture().get();
                            }
                            catch (ExecutionException executionException) {}
                        } else {
                            queue.put(unit);
                        }
                    }
                    catch (InterruptedException exception) {
                        if (CompositeTaskHandlerFactory.this.failPendingOnClose) {
                            onFailure.accept(exception);
                            return;
                        }
                        if (queue == null) break block12;
                        while (true) {
                            try {
                                queue.put(unit);
                            }
                            catch (Throwable throwable2) {
                                continue;
                            }
                            break;
                        }
                    }
                }
                if (queue != null) {
                    result.thenRunAsync(() -> {
                        try {
                            unit.getLatch().countDown();
                        }
                        finally {
                            queue.remove(unit);
                        }
                    }, CompositeTaskHandlerFactory.this.executor);
                }
            }

            @Override
            public void close() {
                block4: {
                    if (queue == null) break block4;
                    if (CompositeTaskHandlerFactory.this.failPendingOnClose) {
                        Unit unit2;
                        while ((unit2 = (Unit)queue.poll()) != null) {
                            unit2.getOnFailure().accept(new TaskHandlerShutdownException());
                        }
                    } else {
                        while (!queue.isEmpty()) {
                            queue.forEach(unit -> {
                                try {
                                    unit.getLatch().await();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            });
                        }
                    }
                }
            }
        };
    }

    static class Unit {
        private final Consumer<Throwable> onFailure;
        private final CountDownLatch latch;

        Unit(Consumer<Throwable> onFailure, CountDownLatch latch) {
            this.onFailure = onFailure;
            this.latch = latch;
        }

        Consumer<Throwable> getOnFailure() {
            return this.onFailure;
        }

        CountDownLatch getLatch() {
            return this.latch;
        }
    }

    static class Registration<CONTEXT, IDENTITY> {
        private final BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>> step;
        private final Set<IDENTITY> dependencies;

        Registration(BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>> step, Set<IDENTITY> dependencies) {
            this.step = step;
            this.dependencies = dependencies;
        }

        BiFunction<Set<Task>, ? super CONTEXT, CompletionStage<Map<Task, TaskDecision>>> getStep() {
            return this.step;
        }

        Set<IDENTITY> getDependencies() {
            return this.dependencies;
        }
    }

    public static enum Mode {
        SEQUENTIAL(Collection::stream),
        PARALLEL(Collection::parallelStream);

        private final Function<Collection<Task>, Stream<Task>> streamer;

        private Mode(Function<Collection<Task>, Stream<Task>> streamer) {
            this.streamer = streamer;
        }

        Stream<Task> stream(Collection<Task> tasks) {
            return this.streamer.apply(tasks);
        }
    }
}

