/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToIntFunction;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskLimiter;

public class PrioritizingTaskLimiter
implements TaskLimiter {
    private final Semaphore semaphore;
    private final ToIntFunction<String> prioritizer;
    private final AtomicLong sequencer = new AtomicLong();
    private final BlockingQueue<Unit> units = new PriorityBlockingQueue<Unit>();

    public PrioritizingTaskLimiter(int concurrency, ToIntFunction<String> prioritizer) {
        this.semaphore = new Semaphore(concurrency);
        this.prioritizer = prioritizer;
    }

    @Override
    public TaskLimiter.Token request(String topic) throws InterruptedException {
        if (!this.semaphore.tryAcquire()) {
            Unit unit = new Unit(this.prioritizer.applyAsInt(topic), this.sequencer.getAndIncrement());
            this.units.put(unit);
            unit.latch.await();
        }
        AtomicBoolean alive = new AtomicBoolean(true);
        return () -> {
            if (alive.getAndSet(false)) {
                Unit queued = (Unit)this.units.poll();
                if (queued == null) {
                    this.semaphore.release();
                } else {
                    queued.latch.countDown();
                }
            }
        };
    }

    static class Unit
    implements Comparable<Unit> {
        private final int priority;
        private final long sequence;
        private final CountDownLatch latch = new CountDownLatch(1);

        Unit(int priority, long sequence) {
            this.priority = priority;
            this.sequence = sequence;
        }

        @Override
        public int compareTo(Unit other) {
            int prioritization = Integer.compare(other.priority, this.priority);
            return prioritization == 0 ? Long.compare(this.sequence, other.sequence) : prioritization;
        }
    }
}

