/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;

public interface TaskListener<TRACE> {
    public void onFatal(String var1, Throwable var2);

    public void onEmpty(String var1);

    public TRACE onStart(String var1, Set<Task> var2);

    public void onDispatched(String var1, TRACE var2, Set<Task> var3);

    public void onCallback(String var1, TRACE var2, Set<Task> var3);

    public void onComplete(String var1, TRACE var2, Map<Task, TaskDecision> var3);

    public void onError(String var1, TRACE var2, Set<Task> var3, Throwable var4);

    public static TaskListener<?> noop() {
        return TaskListener.onFatal(throwable -> {});
    }

    public static TaskListener<?> onFatal(final Consumer<Throwable> consumer) {
        return new TaskListener<Object>(){

            @Override
            public void onFatal(String topic, Throwable throwable) {
                consumer.accept(throwable);
            }

            @Override
            public void onEmpty(String topic) {
            }

            @Override
            public Object onStart(String topic, Set<Task> tasks) {
                return null;
            }

            @Override
            public void onDispatched(String topic, Object trace, Set<Task> tasks) {
            }

            @Override
            public void onCallback(String topic, Object trace, Set<Task> tasks) {
            }

            @Override
            public void onComplete(String topic, Object trace, Map<Task, TaskDecision> decisions) {
            }

            @Override
            public void onError(String topic, Object trace, Set<Task> tasks, Throwable throwable) {
            }
        };
    }
}

