/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskCallback;

@FunctionalInterface
public interface TaskHandler<TRANSACTION, EXCEPTION extends Exception>
extends AutoCloseable {
    public void accept(Set<Task> var1, TaskCallback<TRANSACTION, EXCEPTION> var2, Consumer<Throwable> var3) throws EXCEPTION;

    @Override
    default public void close() {
    }

    default public Supplier<TaskHandler<TRANSACTION, EXCEPTION>> toFactory() {
        return () -> this;
    }

    public static <TRANSACTION, EXCEPTION extends Exception> TaskHandler<TRANSACTION, EXCEPTION> simple(Function<Task, TaskDecision> resolver) {
        return (tasks, callback, onFailure) -> {
            Map decisions = tasks.stream().collect(Collectors.toMap(Function.identity(), resolver));
            callback.accept(transaction -> decisions);
        };
    }
}

