/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskConsumer;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskCreation;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskJuncture;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSink;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskSupplement;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskCompletion;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskContext;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.processor.TaskProcessor;

public class TaskConsumerContext<TRANSACTION, EXCEPTION extends Exception, SUPPLEMENT extends TaskSupplement>
implements TaskConsumer,
TaskContext<TRANSACTION, EXCEPTION, SUPPLEMENT> {
    private final Set<Task> tasks;
    private final TaskSink<TRANSACTION, EXCEPTION> taskSink;
    private final TaskJuncture<TRANSACTION, EXCEPTION> taskJuncture;
    private final Function<String, Optional<TaskProcessor>> processors;
    private final BiFunction<Task, TaskCreation, Stream<TaskCreation>> postprocessor;
    private final Map<String, List<Definition>> definitions = new ConcurrentHashMap<String, List<Definition>>();
    private final Map<String, List<Junction>> junctions = new ConcurrentHashMap<String, List<Junction>>();

    public TaskConsumerContext(Set<Task> tasks, TaskSink<TRANSACTION, EXCEPTION> taskSink, TaskJuncture<TRANSACTION, EXCEPTION> taskJuncture, Function<String, Optional<TaskProcessor>> processors) {
        this.tasks = tasks;
        this.taskSink = taskSink;
        this.taskJuncture = taskJuncture;
        this.processors = processors;
        this.postprocessor = (task, creation) -> Stream.of(creation);
    }

    public TaskConsumerContext(Set<Task> tasks, TaskSink<TRANSACTION, EXCEPTION> taskSink, TaskJuncture<TRANSACTION, EXCEPTION> taskJuncture, Function<String, Optional<TaskProcessor>> processors, BiFunction<Task, TaskCreation, Stream<TaskCreation>> postprocessor) {
        this.tasks = tasks;
        this.taskSink = taskSink;
        this.taskJuncture = taskJuncture;
        this.processors = processors;
        this.postprocessor = postprocessor;
    }

    public void pushByTask(Set<Task> tasks, String topic, TaskSink.Insertion insertion, Function<Task, Collection<TaskCreation>> resolver) {
        if (tasks.isEmpty()) {
            return;
        }
        if (!this.tasks.containsAll(tasks)) {
            throw new IllegalArgumentException("Cannot write tasks for unknown tasks: " + String.valueOf(tasks.stream().filter(task -> !this.tasks.contains(task)).collect(Collectors.toList())));
        }
        this.definitions.computeIfAbsent(topic, ignored -> new CopyOnWriteArrayList()).add(new Definition(tasks, insertion, resolver));
    }

    public void junctionByTask(Map<Task, Set<String>> tasksToIdentifiers, String topic, TaskJuncture.Junction junction) {
        if (tasksToIdentifiers.isEmpty()) {
            return;
        }
        if (!this.tasks.containsAll(tasksToIdentifiers.keySet())) {
            throw new IllegalArgumentException("Cannot write tasks for unknown tasks: " + String.valueOf(tasksToIdentifiers.keySet().stream().filter(task -> !this.tasks.contains(task)).collect(Collectors.toList())));
        }
        this.junctions.computeIfAbsent(topic, ignored -> new CopyOnWriteArrayList()).add(new Junction(tasksToIdentifiers, junction));
    }

    @Override
    public CompletionStage<TaskCompletion<TRANSACTION, EXCEPTION>> apply(Map<Task, TaskDecision> decisions, Executor executor, SUPPLEMENT supplement) {
        CompletableFuture<TaskCompletion<TRANSACTION, EXCEPTION>> future = new CompletableFuture<TaskCompletion<TRANSACTION, EXCEPTION>>();
        if (this.definitions.isEmpty() && this.junctions.isEmpty()) {
            future.complete(transaction -> decisions);
        } else {
            executor.execute(() -> {
                HashSet<String> topics = new HashSet<String>();
                try {
                    TransactionConsumer junctor;
                    TransactionConsumer pusher;
                    Set succeeded = decisions.entrySet().stream().filter(entry -> ((TaskDecision)entry.getValue()).isContinued()).map(Map.Entry::getKey).collect(Collectors.toSet());
                    Map<String, List> definitions = this.definitions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().flatMap(definition -> definition.resolve(succeeded, this.postprocessor).stream()).collect(Collectors.toList())));
                    if (definitions.values().stream().mapToLong(Collection::size).sum() == 0L) {
                        pusher = transaction -> {};
                    } else {
                        topics.addAll(definitions.keySet());
                        pusher = transaction -> {
                            for (Map.Entry entry : definitions.entrySet()) {
                                Iterator it = ((List)entry.getValue()).iterator();
                                ResolvedDefinition current = (ResolvedDefinition)it.next();
                                TaskSink.Insertion insertion = current.getInsertion();
                                ArrayList<TaskCreation> creations = new ArrayList<TaskCreation>(definitions.size());
                                creations.add(current.getCreation());
                                while (it.hasNext()) {
                                    current = (ResolvedDefinition)it.next();
                                    if (current.getInsertion() != insertion) {
                                        this.taskSink.push(transaction, (String)entry.getKey(), insertion, creations);
                                        insertion = current.getInsertion();
                                        creations.clear();
                                    }
                                    creations.add(current.getCreation());
                                }
                                this.taskSink.push(transaction, (String)entry.getKey(), insertion, creations);
                            }
                        };
                    }
                    Map<String, List> junctions = this.junctions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(junction -> junction.resolve(succeeded)).collect(Collectors.toList())));
                    if (junctions.values().stream().mapToLong(Collection::size).sum() == 0L) {
                        junctor = transaction -> {};
                    } else {
                        topics.addAll(junctions.keySet());
                        junctor = transaction -> {
                            for (Map.Entry entry : junctions.entrySet()) {
                                Iterator it = ((List)entry.getValue()).iterator();
                                ResolvedJunction current = (ResolvedJunction)it.next();
                                TaskJuncture.Junction junction = current.getJunction();
                                HashSet<Set<String>> groups = new HashSet<Set<String>>(junctions.size());
                                groups.addAll(current.getGroups());
                                while (it.hasNext()) {
                                    current = (ResolvedJunction)it.next();
                                    if (current.getJunction() != junction) {
                                        this.taskJuncture.junction(transaction, (String)entry.getKey(), junction, groups);
                                        junction = current.getJunction();
                                        groups.clear();
                                    }
                                    groups.addAll(current.getGroups());
                                }
                                this.taskJuncture.junction(transaction, (String)entry.getKey(), junction, groups);
                            }
                        };
                    }
                    if (!topics.isEmpty()) {
                        supplement.register(TopicsToResume.class, (Object)new TopicsToResume(topics));
                    }
                    future.complete(transaction -> {
                        pusher.accept(transaction);
                        junctor.accept(transaction);
                        return decisions;
                    });
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        return future;
    }

    @Override
    public void onAfterTransaction(Executor executor, SUPPLEMENT supplement) {
        supplement.probe(TopicsToResume.class).ifPresent(resume -> executor.execute(() -> resume.getTopics().forEach(topic -> this.processors.apply((String)topic).ifPresent(TaskProcessor::resume))));
    }

    static class Definition {
        private final Set<Task> tasks;
        private final TaskSink.Insertion insertion;
        private final Function<Task, Collection<TaskCreation>> resolver;

        Definition(Set<Task> tasks, TaskSink.Insertion insertion, Function<Task, Collection<TaskCreation>> resolver) {
            this.tasks = tasks;
            this.insertion = insertion;
            this.resolver = resolver;
        }

        List<ResolvedDefinition> resolve(Set<Task> succeeded, BiFunction<Task, TaskCreation, Stream<TaskCreation>> postprocessor) {
            return this.tasks.stream().filter(succeeded::contains).flatMap(task -> this.resolver.apply((Task)task).stream().flatMap(creation -> ((Stream)postprocessor.apply((Task)task, (TaskCreation)creation)).map(transformed -> new ResolvedDefinition(this.insertion, (TaskCreation)transformed)))).collect(Collectors.toList());
        }
    }

    static class Junction {
        private final Map<Task, Set<String>> tasksToIdentifiers;
        private final TaskJuncture.Junction junction;

        Junction(Map<Task, Set<String>> tasksToIdentifiers, TaskJuncture.Junction junction) {
            this.tasksToIdentifiers = tasksToIdentifiers;
            this.junction = junction;
        }

        ResolvedJunction resolve(Set<Task> succeeded) {
            return new ResolvedJunction(this.junction, this.tasksToIdentifiers.entrySet().stream().filter(entry -> succeeded.contains(entry.getKey())).map(entry -> {
                HashSet<String> identifiers = new HashSet<String>((Collection)entry.getValue());
                identifiers.add(((Task)entry.getKey()).getIdentifier());
                return identifiers;
            }).collect(Collectors.toList()));
        }
    }

    static class TopicsToResume {
        private final Set<String> topics;

        TopicsToResume(Set<String> topics) {
            this.topics = topics;
        }

        Set<String> getTopics() {
            return this.topics;
        }
    }

    static interface TransactionConsumer<TRANSACTION, EXCEPTION extends Exception> {
        public void accept(TRANSACTION var1) throws EXCEPTION;
    }

    static class ResolvedJunction {
        private final TaskJuncture.Junction junction;
        private final Collection<Set<String>> groups;

        ResolvedJunction(TaskJuncture.Junction junction, Collection<Set<String>> groups) {
            this.junction = junction;
            this.groups = groups;
        }

        TaskJuncture.Junction getJunction() {
            return this.junction;
        }

        Collection<Set<String>> getGroups() {
            return this.groups;
        }
    }

    static class ResolvedDefinition {
        private final TaskSink.Insertion insertion;
        private final TaskCreation creation;

        ResolvedDefinition(TaskSink.Insertion insertion, TaskCreation creation) {
            this.creation = creation;
            this.insertion = insertion;
        }

        TaskSink.Insertion getInsertion() {
            return this.insertion;
        }

        TaskCreation getCreation() {
            return this.creation;
        }
    }
}

