/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprTag;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public sealed interface ESExpr {
    @NotNull
    public static final @NotNull ESExprCodec<@NotNull ESExpr> CODEC = new ESExprCodec<ESExpr>(){

        @Override
        @NotNull
        public @NotNull Set<@NotNull ESExprTag> tags() {
            return Set.of();
        }

        @Override
        @NotNull
        public ESExpr encode(@NotNull ESExpr value) {
            return value;
        }

        @Override
        @NotNull
        public ESExpr decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
            return expr;
        }
    };

    @NotNull
    public ESExprTag tag();

    @NotNull
    public static @NotNull ESExprCodec<@NotNull ESExpr> codec() {
        return CODEC;
    }

    public record Null(BigInteger level) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Null();
        }
    }

    public record Float64(double d) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Float64();
        }
    }

    public record Float32(float f) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Float32();
        }
    }

    public record Binary(byte @NotNull [] b) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Binary();
        }
    }

    public record Str(@NotNull String s) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Str();
        }
    }

    public record Int(@NotNull BigInteger n) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Int();
        }
    }

    public record Bool(boolean b) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Bool();
        }
    }

    public record Constructor(@NotNull String constructor, @NotNull @NotNull List<@NotNull ESExpr> args, @NotNull @NotNull Map<@NotNull String, @NotNull ESExpr> kwargs) implements ESExpr
    {
        @Override
        @NotNull
        public ESExprTag tag() {
            return new ESExprTag.Constructor(this.constructor);
        }
    }
}

