/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.BinToken;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.StringTable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ESExprBinaryWriter {
    private final List<? extends @NotNull String> symbolTable;
    private final OutputStream os;

    public ESExprBinaryWriter(@NotNull @NotNull List<? extends @NotNull String> symbolTable, OutputStream os) {
        this.symbolTable = symbolTable;
        this.os = os;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void write(ESExpr expr) throws IOException {
        block35: {
            v0 = expr;
            Objects.requireNonNull(v0);
            var2_2 = v0;
            var3_4 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ESExpr.Constructor.class, ESExpr.Bool.class, ESExpr.Int.class, ESExpr.Str.class, ESExpr.Binary.class, ESExpr.Float32.class, ESExpr.Float64.class, ESExpr.Null.class}, (Object)var2_2, var3_4)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    var4_5 = (ESExpr.Constructor)var2_2;
                    var8_6 = var4_5.constructor();
                    constructor = var8_6;
                    var8_6 = var4_5.args();
                    args = var8_6;
                    var8_6 = var4_5.kwargs();
                    kwargs = var8_6;
                    var8_6 = constructor;
                    var9_11 = -1;
                    switch (var8_6.hashCode()) {
                        case -1007575278: {
                            if (!var8_6.equals("string-table")) break;
                            var9_11 = 0;
                            break;
                        }
                        case 3322014: {
                            if (!var8_6.equals("list")) break;
                            var9_11 = 1;
                        }
                    }
                    switch (var9_11) {
                        case 0: {
                            this.writeToken(BinToken.Fixed.CONSTRUCTOR_START_STRING_TABLE);
                            break;
                        }
                        case 1: {
                            this.writeToken(BinToken.Fixed.CONSTRUCTOR_START_LIST);
                            break;
                        }
                        default: {
                            index = this.getSymbolIndex(constructor);
                            this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.CONSTRUCTOR, index));
                        }
                    }
                    var8_6 = args.iterator();
                    while (var8_6.hasNext()) {
                        arg = (ESExpr)var8_6.next();
                        this.write(arg);
                    }
                    for (Map.Entry pair : kwargs.entrySet()) {
                        this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.KEYWORD, this.getSymbolIndex((String)pair.getKey())));
                        this.write((ESExpr)pair.getValue());
                    }
                    this.writeToken(BinToken.Fixed.CONSTRUCTOR_END);
                    break;
                }
                case 1: {
                    var8_7 = (ESExpr.Bool)var2_2;
                    b = var10_16 = var8_7.b();
                    if (!b) ** GOTO lbl58
                    this.writeToken(BinToken.Fixed.TRUE);
                    break;
lbl58:
                    // 1 sources

                    this.writeToken(BinToken.Fixed.FALSE);
                    break;
                }
                case 2: {
                    var10_17 = (ESExpr.Int)var2_2;
                    i = var12_18 = var10_17.n();
                    if (i.signum() >= 0) ** GOTO lbl67
                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.NEG_INT, i.negate().subtract(BigInteger.ONE)));
                    break;
lbl67:
                    // 1 sources

                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.INT, i));
                    break;
                }
                case 3: {
                    var12_19 = (ESExpr.Str)var2_2;
                    s = var14_21 = var12_19.s();
                    b = s.getBytes(StandardCharsets.UTF_8);
                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.STRING, BigInteger.valueOf(b.length)));
                    this.os.write(b);
                    break;
                }
                case 4: {
                    var14_22 = (ESExpr.Binary)var2_2;
                    b = var16_24 = var14_22.b();
                    this.writeToken(new BinToken.WithInteger(BinToken.WithIntegerType.BINARY, BigInteger.valueOf(b.length)));
                    this.os.write(b);
                    break;
                }
                case 5: {
                    var16_25 = (ESExpr.Float32)var2_2;
                    f = var18_27 = var16_25.f();
                    this.writeToken(BinToken.Fixed.FLOAT32);
                    bits = Float.floatToRawIntBits(f);
                    for (i = 0; i < 4; ++i) {
                        this.os.write(bits & 255);
                        bits >>>= 8;
                    }
                    break block35;
                }
                case 6: {
                    var18_29 = (ESExpr.Float64)var2_2;
                    d = var21_33 = var18_29.d();
                    this.writeToken(BinToken.Fixed.FLOAT64);
                    bits = Double.doubleToRawLongBits(d);
                    for (i = 0; i < 8; ++i) {
                        this.os.write((int)bits & 255);
                        bits >>>= 8;
                    }
                    break block35;
                }
                case 7: {
                    var21_35 = (ESExpr.Null)var2_2;
                    level = var23_37 = var21_35.level();
                    if (!level.equals(BigInteger.ZERO)) ** GOTO lbl113
                    this.writeToken(BinToken.Fixed.NULL0);
                    break;
lbl113:
                    // 1 sources

                    if (level.equals(BigInteger.ONE)) {
                        this.writeToken(BinToken.Fixed.NULL1);
                        break;
                    }
                    if (level.equals(BigInteger.valueOf(2L))) {
                        this.writeToken(BinToken.Fixed.NULL2);
                        break;
                    }
                    this.writeToken(BinToken.Fixed.NULLN);
                    this.writeInt(level.subtract(BigInteger.valueOf(3L)));
                }
            }
            break block35;
            catch (Throwable var2_3) {
                throw new MatchException(var2_3.toString(), var2_3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToken(BinToken token) throws IOException {
        BinToken binToken = token;
        Objects.requireNonNull(binToken);
        BinToken binToken2 = binToken;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinToken.WithInteger.class, BinToken.Fixed.class}, (Object)binToken2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                boolean isPos;
                Object value;
                BinToken.WithIntegerType type;
                BinToken.WithInteger withInteger = (BinToken.WithInteger)binToken2;
                try {
                    Object object = withInteger.type();
                    type = object;
                    value = object = withInteger.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                int b = switch (type) {
                    default -> throw new MatchException(null, null);
                    case BinToken.WithIntegerType.CONSTRUCTOR -> 0;
                    case BinToken.WithIntegerType.INT -> 32;
                    case BinToken.WithIntegerType.NEG_INT -> 64;
                    case BinToken.WithIntegerType.STRING -> 96;
                    case BinToken.WithIntegerType.STRING_POOL_INDEX -> 128;
                    case BinToken.WithIntegerType.BINARY -> 160;
                    case BinToken.WithIntegerType.KEYWORD -> 192;
                };
                b |= ((Number)value).byteValue() & 0xF;
                value = ((BigInteger)value).shiftRight(4);
                boolean bl = isPos = ((BigInteger)value).signum() > 0;
                if (isPos) {
                    b |= 0x10;
                }
                this.os.write(b);
                if (!isPos) return;
                this.writeInt((BigInteger)value);
                return;
            }
            case 1: 
        }
        BinToken.Fixed fixed = (BinToken.Fixed)binToken2;
        int b = switch (fixed) {
            default -> throw new MatchException(null, null);
            case BinToken.Fixed.CONSTRUCTOR_END -> 224;
            case BinToken.Fixed.TRUE -> 225;
            case BinToken.Fixed.FALSE -> 226;
            case BinToken.Fixed.NULL0 -> 227;
            case BinToken.Fixed.FLOAT32 -> 228;
            case BinToken.Fixed.FLOAT64 -> 229;
            case BinToken.Fixed.CONSTRUCTOR_START_STRING_TABLE -> 230;
            case BinToken.Fixed.CONSTRUCTOR_START_LIST -> 231;
            case BinToken.Fixed.NULL1 -> 232;
            case BinToken.Fixed.NULL2 -> 233;
            case BinToken.Fixed.NULLN -> 234;
        };
        this.os.write(b);
    }

    private BigInteger getSymbolIndex(String symbol) {
        int index = this.symbolTable.indexOf(symbol);
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return BigInteger.valueOf(index);
    }

    private void writeInt(BigInteger value) throws IOException {
        do {
            int b = value.byteValue() & 0x7F;
            if ((value = value.shiftRight(7)).signum() > 0) {
                b |= 0x80;
            }
            this.os.write(b);
        } while (value.signum() > 0);
    }

    @NotNull
    public static StringTable buildSymbolTable(@NotNull ESExpr expr) {
        SymbolTableBuilder builder = new SymbolTableBuilder();
        builder.add(expr);
        return builder.build();
    }

    public static void writeWithSymbolTable(@NotNull OutputStream os, @NotNull ESExpr expr) throws IOException {
        StringTable st = ESExprBinaryWriter.buildSymbolTable(expr);
        new ESExprBinaryWriter(List.of(), os).write(StringTable.codec().encode(st));
        new ESExprBinaryWriter(st.values(), os).write(expr);
    }

    public static final class SymbolTableBuilder {
        private final Set<String> st = new HashSet<String>();

        public void add(@NotNull ESExpr expr) {
            if (expr instanceof ESExpr.Constructor) {
                Map<String, ESExpr> kwargs;
                Map<String, ESExpr> args;
                Iterator<Map.Entry<String, ESExpr>> iterator;
                block7: {
                    ESExpr.Constructor constructor = (ESExpr.Constructor)expr;
                    iterator = constructor.constructor();
                    String name = iterator;
                    iterator = constructor.args();
                    args = iterator;
                    try {
                        iterator = constructor.kwargs();
                        kwargs = iterator;
                        if (name.equals("string-table") || name.equals("list")) break block7;
                        this.st.add(name);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                iterator = args.iterator();
                while (iterator.hasNext()) {
                    ESExpr arg = (ESExpr)iterator.next();
                    this.add(arg);
                }
                for (Map.Entry<String, ESExpr> kwarg : kwargs.entrySet()) {
                    this.st.add(kwarg.getKey());
                    this.add(kwarg.getValue());
                }
            }
        }

        @NotNull
        public StringTable build() {
            return new StringTable(this.st.stream().toList());
        }
    }
}

