/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.DictCodec;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public record KeywordMapping<T>(@NotNull Map<String, T> map) {
    public static <T> ESExprCodec<KeywordMapping<T>> codec(final ESExprCodec<T> tCodec) {
        return new ESExprCodec<KeywordMapping<T>>(){
            private static final String DICT_CONSTRUCTOR = "dict";

            @Override
            @NotNull
            public @NotNull Set<@NotNull ESExprTag> tags() {
                return Set.of(new ESExprTag.Constructor(DICT_CONSTRUCTOR));
            }

            @Override
            @NotNull
            public ESExpr encode(@NotNull KeywordMapping<T> value) {
                Map<String, ESExpr> map = KeywordMapping.dictCodec(tCodec).encodeDict(value);
                return new ESExpr.Constructor(DICT_CONSTRUCTOR, List.of(), map);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @NotNull
            public KeywordMapping<T> decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
                String name;
                Map<String, ESExpr> map;
                if (!(expr instanceof ESExpr.Constructor)) throw new DecodeException("Expected a dict constructor.", path);
                ESExpr.Constructor constructor = (ESExpr.Constructor)expr;
                try {
                    map = constructor.constructor();
                    name = map;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Map<String, ESExpr> args = map = constructor.args();
                Map<String, ESExpr> kwargs = map = constructor.kwargs();
                if (!name.equals(DICT_CONSTRUCTOR)) throw new DecodeException("Expected a dict constructor.", path);
                if (args.isEmpty()) return KeywordMapping.dictCodec(tCodec).decodeDict(kwargs, kw -> path.append(name, kw));
                throw new DecodeException("Invalid positional arguments for dict", path.withConstructor(name));
            }
        };
    }

    public static <T> DictCodec<KeywordMapping<T>> dictCodec(final ESExprCodec<T> tCodec) {
        return new DictCodec<KeywordMapping<T>>(){

            @Override
            public Map<String, ESExpr> encodeDict(KeywordMapping<T> value) {
                HashMap<String, ESExpr> map = new HashMap<String, ESExpr>();
                for (Map.Entry entry : value.map().entrySet()) {
                    map.put(entry.getKey(), tCodec.encode(entry.getValue()));
                }
                return map;
            }

            @Override
            public KeywordMapping<T> decodeDict(Map<String, ESExpr> exprs, @NotNull DictCodec.KeywordPathBuilder pathBuilder) throws DecodeException {
                HashMap values = new HashMap();
                int i = 0;
                for (Map.Entry<String, ESExpr> entry : exprs.entrySet()) {
                    Object value = tCodec.decode(entry.getValue(), pathBuilder.pathAt(entry.getKey()));
                    values.put(entry.getKey(), value);
                    ++i;
                }
                return new KeywordMapping(values);
            }
        };
    }
}

