/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BooleanESExprCodec
extends ESExprCodec<Boolean> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=boolean.class), @ESExprOverrideCodec(value=Boolean.class)})
    public static final ESExprCodec<Boolean> INSTANCE = new BooleanESExprCodec();

    private BooleanESExprCodec() {
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Bool());
    }

    @Override
    @NotNull
    public ESExpr encode(@NotNull Boolean value) {
        return new ESExpr.Bool(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Boolean decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        boolean b;
        if (!(expr instanceof ESExpr.Bool)) throw new DecodeException("Expected a boolean value", path);
        ESExpr.Bool bool = (ESExpr.Bool)expr;
        try {
            boolean bl;
            b = bl = bool.b();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return b;
    }
}

