/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FloatCodec
extends ESExprCodec<Float> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=float.class), @ESExprOverrideCodec(value=Float.class)})
    public static final ESExprCodec<Float> INSTANCE = new FloatCodec();

    private FloatCodec() {
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Float32());
    }

    @Override
    @NotNull
    public ESExpr encode(@NotNull Float value) {
        return new ESExpr.Float32(value.floatValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Float decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        float f2;
        if (!(expr instanceof ESExpr.Float32)) throw new DecodeException("Expected a float value", path);
        ESExpr.Float32 float32 = (ESExpr.Float32)expr;
        try {
            float f;
            f2 = f = float32.f();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Float.valueOf(f2);
    }
}

