/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StringCodec
extends ESExprCodec<String> {
    @ESExprOverrideCodec(value=String.class)
    public static final ESExprCodec<String> INSTANCE = new StringCodec();

    private StringCodec() {
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Str());
    }

    @Override
    @NotNull
    public ESExpr encode(@NotNull String value) {
        return new ESExpr.Str(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Str)) throw new DecodeException("Expected a string value", path);
        ESExpr.Str str = (ESExpr.Str)expr;
        try {
            String string = str.s();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

