/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;

public class BooleanCodec
extends ESExprCodec<Boolean> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=boolean.class), @ESExprOverrideCodec(value=Boolean.class)})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.BOOL})
    public static final ESExprCodec<Boolean> INSTANCE = new BooleanCodec();

    private BooleanCodec() {
    }

    @Override
    public boolean isEncodedEqual(Boolean x, Boolean y) {
        return x.booleanValue() == y.booleanValue();
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.BOOL);
    }

    @Override
    public ESExpr encode(Boolean value) {
        return new ESExpr.Bool(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        boolean b;
        if (!(expr instanceof ESExpr.Bool)) throw new DecodeException("Expected a boolean value", path);
        ESExpr.Bool bool = (ESExpr.Bool)expr;
        try {
            boolean bl;
            b = bl = bool.b();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return b;
    }
}

