/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import java.util.Arrays;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;

public class ByteArrayCodec
extends ESExprCodec<byte[]> {
    @ESExprOverrideCodec(value=byte[].class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY8})
    public static final ESExprCodec<byte[]> INSTANCE = new ByteArrayCodec();

    private ByteArrayCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY8);
    }

    @Override
    public boolean isEncodedEqual(byte[] x, byte[] y) {
        return Arrays.equals(x, y);
    }

    @Override
    public ESExpr encode(byte[] value) {
        return new ESExpr.Array8(ByteLists.immutable.of(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        ImmutableByteList b;
        if (!(expr instanceof ESExpr.Array8)) throw new DecodeException("Expected an array8 value", path);
        ESExpr.Array8 array8 = (ESExpr.Array8)expr;
        try {
            ImmutableByteList immutableByteList;
            b = immutableByteList = array8.b();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return b.toArray();
    }
}

