/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;

public class FloatCodec
extends ESExprCodec<Float> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=float.class), @ESExprOverrideCodec(value=Float.class)})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.FLOAT32})
    public static final ESExprCodec<Float> INSTANCE = new FloatCodec();

    private FloatCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.FLOAT32);
    }

    @Override
    public boolean isEncodedEqual(Float x, Float y) {
        return Float.floatToRawIntBits(x.floatValue()) == Float.floatToRawIntBits(y.floatValue());
    }

    @Override
    public ESExpr encode(Float value) {
        return new ESExpr.Float32(value.floatValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Float decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        float f2;
        if (!(expr instanceof ESExpr.Float32)) throw new DecodeException("Expected a float value", path);
        ESExpr.Float32 float32 = (ESExpr.Float32)expr;
        try {
            float f;
            f2 = f = float32.f();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return Float.valueOf(f2);
    }
}

