/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;

public class ImmutableIntListCodec
extends ESExprCodec<ImmutableIntList> {
    @ESExprOverrideCodec(value=ImmutableIntList.class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY32})
    public static final ESExprCodec<ImmutableIntList> INSTANCE = new ImmutableIntListCodec();

    private ImmutableIntListCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY32);
    }

    @Override
    public boolean isEncodedEqual(ImmutableIntList x, ImmutableIntList y) {
        return x.equals((Object)y);
    }

    @Override
    public ESExpr encode(ImmutableIntList value) {
        return new ESExpr.Array32(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ImmutableIntList decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Array32)) throw new DecodeException("Expected an array8 value", path);
        ESExpr.Array32 array32 = (ESExpr.Array32)expr;
        try {
            ImmutableIntList immutableIntList = array32.b();
            return immutableIntList;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

