/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.Unsigned;
import dev.argon.esexpr.codecs.IntCodecBase;
import java.math.BigInteger;

public class UnsignedIntegerCodec
extends IntCodecBase<Integer> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=int.class, requiredAnnotations={Unsigned.class}), @ESExprOverrideCodec(value=Integer.class, requiredAnnotations={Unsigned.class})})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.INT})
    public static final ESExprCodec<Integer> INSTANCE = new UnsignedIntegerCodec();

    private UnsignedIntegerCodec() {
        super(BigInteger.ZERO, BigInteger.valueOf(0xFFFFFFFFL));
    }

    @Override
    public boolean isEncodedEqual(Integer x, Integer y) {
        return x.equals(y);
    }

    @Override
    protected Integer fromBigInt(BigInteger value) {
        return value.intValue();
    }

    @Override
    protected BigInteger toBigInt(Integer value) {
        return BigInteger.valueOf(Integer.toUnsignedLong(value));
    }
}

