/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.VarargCodec;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

@ESExprOverrideCodec(value=List.class, codecType=ESExprOverrideCodec.CodecType.VARARG)
public class ListVarargCodec<T>
implements VarargCodec<List<T>, T> {
    private final ESExprCodec<T> elementCodec;

    public ListVarargCodec(ESExprCodec<T> elementCodec) {
        this.elementCodec = elementCodec;
    }

    @Override
    public boolean isEncodedEqual(List<T> x, List<T> y) {
        if (x.size() != y.size()) {
            return false;
        }
        for (int i = 0; i < x.size(); ++i) {
            if (this.elementCodec.isEncodedEqual(x.get(i), y.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encodeVararg(List<T> value, List<ESExpr> exprs) {
        for (T elem : value) {
            exprs.add(this.elementCodec.encode(elem));
        }
    }

    @Override
    public List<T> decodeVararg(Deque<ESExpr> exprs, VarargCodec.PositionalPathBuilder pathBuilder) throws DecodeException {
        ESExpr expr;
        ArrayList<T> values = new ArrayList<T>(exprs.size());
        int i = 0;
        while ((expr = exprs.peekFirst()) != null && this.elementCodec.tags().contains(expr.tag())) {
            exprs.removeFirst();
            T value = this.elementCodec.decode(expr, pathBuilder.pathAt(i));
            values.add(value);
            ++i;
        }
        return values;
    }
}

