/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.Unsigned;
import dev.argon.esexpr.codecs.IntCodecBase;
import java.math.BigInteger;

public class UnsignedLongCodec
extends IntCodecBase<Long> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=long.class, requiredAnnotations={Unsigned.class}), @ESExprOverrideCodec(value=Long.class, requiredAnnotations={Unsigned.class})})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.INT})
    public static final ESExprCodec<Long> INSTANCE = new UnsignedLongCodec();

    private UnsignedLongCodec() {
        super(BigInteger.ZERO, BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE));
    }

    @Override
    public boolean isEncodedEqual(Long x, Long y) {
        return x.longValue() == y.longValue();
    }

    @Override
    protected Long fromBigInt(BigInteger value) {
        return value.longValue();
    }

    @Override
    protected BigInteger toBigInt(Long value) {
        return BigInteger.valueOf(value).and(BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE));
    }
}

