/*
 * Decompiled with CFR 0.152.
 */
package dev.fneira.interfaceprocessor;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;

public class InterfaceProcessorFactoryBean
implements FactoryBean<Object>,
InitializingBean,
BeanFactoryAware {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private BeanFactory beanFactory;
    private Class<?> type;
    private Class<? extends MethodInterceptor> handler;

    <T> T createProxyForInterface() {
        this.logger.info("Creating proxy for interface: " + this.type);
        return (T)Enhancer.create(this.type, (Callback)((Callback)this.beanFactory.getBean(this.handler)));
    }

    public void afterPropertiesSet() {
        Objects.requireNonNull(this.type, "Property 'type' is required");
        Objects.requireNonNull(this.handler, "Property 'handler' is required");
    }

    public Object getObject() {
        return this.createProxyForInterface();
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public void setBeanFactory(@Nonnull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setHandler(Class<? extends MethodInterceptor> handler) {
        this.handler = handler;
    }
}

