/*
 * Decompiled with CFR 0.152.
 */
package dev.fneira.interfaceprocessor;

import dev.fneira.interfaceprocessor.EnableInterfaceProcessor;
import dev.fneira.interfaceprocessor.InterfaceProcessorFactoryBean;
import dev.fneira.interfaceprocessor.InterfaceProcessorHandler;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class InterfaceProcessorScannerRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ResourceLoaderAware {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Environment environment;
    private ResourceLoader resourceLoader;

    public void registerBeanDefinitions(@Nonnull AnnotationMetadata metadata, @Nonnull BeanDefinitionRegistry registry) {
        this.logger.info("Bean registration started");
        this.getBasePackages(metadata).stream().map(basePackage -> this.getScanner().findCandidateComponents(basePackage)).flatMap(Collection::stream).map(this::getTargetClass).peek(targetClass -> this.logger.info("Registering bean for " + targetClass)).forEach(candidateComponent -> this.registerBeanForInterface(registry, (Class)candidateComponent));
        this.logger.info("Bean registration completed");
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    return !beanDefinition.getMetadata().isAnnotation();
                }
                return false;
            }
        };
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(InterfaceProcessorHandler.class));
        return scanner;
    }

    private Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Object[] basePackagesValue = Optional.ofNullable(importingClassMetadata.getAnnotationAttributes(EnableInterfaceProcessor.class.getCanonicalName())).map(attributes -> (String[])attributes.get("basePackages")).orElse(new String[0]);
        Set<String> basePackages = Stream.of(basePackagesValue).filter(StringUtils::hasText).collect(Collectors.toSet());
        if (basePackages.isEmpty()) {
            String defaultBasePackage = ClassUtils.getPackageName((String)importingClassMetadata.getClassName());
            this.logger.info("basePackages value is not present in @EnableInterfaceProxy, using default value: " + defaultBasePackage);
            basePackages.add(defaultBasePackage);
        } else {
            this.logger.info("basePackages value is present in @EnableInterfaceProxy: " + Arrays.toString(basePackagesValue));
        }
        return basePackages;
    }

    private Class<?> getTargetClass(BeanDefinition candidateComponent) {
        if (candidateComponent instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
            AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
            Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@ProxyHandler can only be specified on an interface");
            return this.getClass(beanDefinition.getBeanClassName());
        }
        throw new RuntimeException("Bean definition is not an instance of AnnotatedBeanDefinition");
    }

    private <T> void registerBeanForInterface(BeanDefinitionRegistry registry, Class<T> targetClass) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(InterfaceProcessorFactoryBean.class).addPropertyValue("type", targetClass).addPropertyValue("handler", this.getHandler(targetClass)).getRawBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", targetClass);
        beanDefinition.setPrimary(true);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)beanDefinition, targetClass.getSimpleName()), (BeanDefinitionRegistry)registry);
    }

    private Class<?> getHandler(Class<?> targetClass) {
        return Stream.of(targetClass.getAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(InterfaceProcessorHandler.class)).map(annotation -> annotation.annotationType().getAnnotation(InterfaceProcessorHandler.class).value()).findFirst().orElseThrow();
    }

    private Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(@Nonnull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

