/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class SSEHandler
implements SimpleHttpHandler {
    private final List<OutputStream> listeners = new ArrayList<OutputStream>();
    private final AtomicInteger eventID = new AtomicInteger(-1);
    private final List<EventStreamRecord> queue = new ArrayList<EventStreamRecord>();

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        Headers responseHeaders = exchange.getResponseHeaders();
        responseHeaders.add("Access-Control-Allow-Headers", "Content-Type");
        if (exchange.getRequestHeaders().getFirst("origin") != null) {
            responseHeaders.add("Access-Control-Allow-Origin", exchange.getRequestHeaders().getFirst("origin"));
        }
        responseHeaders.add("Access-Control-Allow-Methods", "GET, HEAD, POST, PUT, DELETE");
        responseHeaders.add("Access-Control-Max-Age", "3600");
        responseHeaders.add("Cache-Control", "no-cache");
        if (exchange.getRequestMethod().equalsIgnoreCase("options")) {
            exchange.send(200);
            return;
        }
        responseHeaders.put("Content-Type", Collections.singletonList("text/event-stream"));
        int latest = 0;
        try {
            latest = Integer.parseInt(exchange.getRequestHeaders().getFirst("Last_Event-ID"));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        exchange.send(200);
        for (int index = latest; index < this.queue.size(); ++index) {
            exchange.getResponseBody().write(this.queue.get(index).toString(this.eventID.get()).getBytes(StandardCharsets.UTF_8));
            exchange.getResponseBody().flush();
        }
        this.listeners.add(exchange.getResponseBody());
    }

    public final synchronized void push(String data) {
        this.push(data, 0, "");
    }

    public final synchronized void push(String data, int retry, String event) {
        this.eventID.addAndGet(1);
        EventStreamRecord record = new EventStreamRecord(retry, event, data);
        this.queue.add(record);
        for (OutputStream OUT : this.listeners) {
            try {
                OUT.write(record.toString(this.eventID.get()).getBytes(StandardCharsets.UTF_8));
                OUT.flush();
            }
            catch (IOException ignored) {
                this.listeners.remove(OUT);
            }
        }
    }

    public String toString() {
        return "SSEHandler{listeners=" + this.listeners + ", eventID=" + this.eventID + ", queue=" + this.queue + '}';
    }

    private static class EventStreamRecord {
        private final int retry;
        private final String event;
        private final String data;

        private EventStreamRecord(int retry, String event, String data) {
            this.retry = retry;
            this.event = event;
            this.data = data;
        }

        private String toString(int id) {
            return "id: " + id + '\n' + (this.retry > 0 ? "retry: " + this.retry + '\n' : "") + (!this.event.trim().isEmpty() ? "event: " + this.event + '\n' : "") + (!this.data.trim().isEmpty() ? "data: " + this.data + '\n' : "") + '\n';
        }
    }
}

