/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.file;

import com.sun.net.httpserver.HttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpHandler;
import dev.katsute.simplehttpserver.handler.file.ContextUtility;
import dev.katsute.simplehttpserver.handler.file.DirectoryEntry;
import dev.katsute.simplehttpserver.handler.file.FileAdapter;
import dev.katsute.simplehttpserver.handler.file.FileEntry;
import dev.katsute.simplehttpserver.handler.file.FileOptions;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class FileHandler
implements SimpleHttpHandler {
    private static final FileOptions defaultOptions = new FileOptions();
    private static final FileAdapter defaultAdapter = new FileAdapter(){

        @Override
        public final byte[] getBytes(File file, byte[] bytes) {
            return bytes;
        }

        @Override
        public final String getName(File file) {
            return FileHandler.getName(file);
        }
    };
    private final FileAdapter adapter;
    private final Map<String, FileEntry> files = new ConcurrentHashMap<String, FileEntry>();
    private final Map<String, DirectoryEntry> directories = new ConcurrentHashMap<String, DirectoryEntry>();

    private static String getName(File file) {
        return Objects.requireNonNull(file).getParentFile() == null ? file.getPath() : file.getName();
    }

    public FileHandler() {
        this(defaultAdapter);
    }

    public FileHandler(FileAdapter adapter) {
        this.adapter = Objects.requireNonNull(adapter);
    }

    public final void addFile(File file) {
        this.addFile(file, this.adapter.getName(file), null);
    }

    public final void addFile(File file, FileOptions options) {
        this.addFile(file, this.adapter.getName(file), options);
    }

    public final void addFile(File file, String fileName) {
        this.addFile(file, fileName, null);
    }

    public final void addFile(File file, String fileName, FileOptions options) {
        Objects.requireNonNull(file);
        try {
            FileOptions opts = options == null ? defaultOptions : new FileOptions(options);
            Objects.requireNonNull(opts.loading);
            Objects.requireNonNull(opts.context);
            this.files.put(ContextUtility.joinContexts(true, false, opts.context, fileName == null ? this.adapter.getName(file) : fileName), new FileEntry(file, this.adapter, opts));
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    public final void addFiles(File[] files) {
        this.addFiles(files, null);
    }

    public final void addFiles(File[] files, FileOptions options) {
        for (File file : Objects.requireNonNull(files)) {
            this.addFile(file, options);
        }
    }

    public final void addDirectory(File directory) {
        this.addDirectory(directory, FileHandler.getName(directory), null);
    }

    public final void addDirectory(File directory, FileOptions options) {
        this.addDirectory(directory, FileHandler.getName(directory), options);
    }

    public final void addDirectory(File directory, String directoryName) {
        this.addDirectory(directory, directoryName, null);
    }

    public final void addDirectory(File directory, String directoryName, FileOptions options) {
        Objects.requireNonNull(directory);
        try {
            FileOptions opts = options == null ? defaultOptions : new FileOptions(options);
            Objects.requireNonNull(opts.loading);
            Objects.requireNonNull(opts.context);
            String target = ContextUtility.joinContexts(true, false, opts.context, directoryName);
            this.directories.put(target, new DirectoryEntry(directory, this.adapter, opts));
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    public final void removeFile(String context) {
        this.files.remove(ContextUtility.getContext(Objects.requireNonNull(context), true, false));
    }

    public final void removeFile(File file) {
        this.removeFile(this.adapter.getName(Objects.requireNonNull(file)));
    }

    public final void removeFile(File file, FileOptions options) {
        this.removeFile(ContextUtility.joinContexts(true, false, options.context, this.adapter.getName(Objects.requireNonNull(file))));
    }

    public final void removeDirectory(String context) {
        this.directories.remove(ContextUtility.getContext(Objects.requireNonNull(context), true, false));
    }

    public final void removeDirectory(File directory) {
        this.removeDirectory(FileHandler.getName(directory));
    }

    public final void removeDirectory(File directory, FileOptions options) {
        this.removeDirectory(ContextUtility.joinContexts(true, false, options.context, FileHandler.getName(directory)));
    }

    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        String context = URLDecoder.decode(ContextUtility.getContext(exchange.getRequestURI().getPath().substring(exchange.getHttpContext().getPath().length()), true, false), "UTF-8");
        boolean refreshExpired = false;
        if (this.files.containsKey(context)) {
            FileEntry entry = this.files.get(context);
            if (entry.isExpired()) {
                refreshExpired = true;
                entry.clearBytes();
            }
            this.handle(exchange, entry.getFile(), entry.getBytes());
        } else {
            String match = "";
            for (String key : this.directories.keySet()) {
                if (!context.startsWith(key) || !key.startsWith(match)) continue;
                match = key;
            }
            if (match.isEmpty()) {
                this.handle(exchange, null, null);
            } else {
                String rel;
                DirectoryEntry dir2 = this.directories.get(match);
                FileEntry entry = dir2.getFileEntry(rel = context.substring(match.length()));
                if (entry != null && entry.isExpired()) {
                    refreshExpired = true;
                    entry.clearBytes();
                }
                this.handle(exchange, entry == null ? dir2.getFile(rel) : entry.getFile(), entry == null ? dir2.getBytes(rel) : entry.getBytes());
            }
        }
        exchange.close();
        if (refreshExpired) {
            this.files.values().stream().filter(FileEntry::isExpired).forEach(FileEntry::clearBytes);
            this.directories.values().forEach(dir -> dir.getFiles().values().stream().filter(FileEntry::isExpired).forEach(FileEntry::clearBytes));
        }
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    public void handle(SimpleHttpExchange exchange, File source, byte[] bytes) throws IOException {
        exchange.send(bytes, 200);
    }

    public String toString() {
        return "FileHandler{adapter=" + this.adapter + ", files=" + this.files + ", directories=" + this.directories + '}';
    }
}

