/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.throttler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpHandler;
import dev.katsute.simplehttpserver.handler.throttler.ConnectionThrottler;
import java.io.IOException;

public class ThrottledHandler
implements SimpleHttpHandler {
    private final HttpHandler handler;
    private final ConnectionThrottler throttler;

    public ThrottledHandler(ConnectionThrottler throttler, HttpHandler handler) {
        this.handler = handler;
        this.throttler = throttler;
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        if (this.throttler.addConnection(exchange)) {
            try {
                this.handler.handle(exchange);
            }
            finally {
                this.throttler.deleteConnection(exchange);
            }
        }
        exchange.close();
    }

    public String toString() {
        return "ThrottledHandler{handler=" + this.handler + ", throttler=" + this.throttler + '}';
    }
}

