/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.file;

public class FileOptions {
    public String context = "";
    public FileLoadingOption loading = FileLoadingOption.LIVE;
    public long cache = 0L;
    public boolean walk = false;

    public FileOptions() {
    }

    FileOptions(FileOptions options) {
        this.context = options.context;
        this.loading = options.loading;
        this.cache = options.cache;
        this.walk = options.walk;
    }

    public String toString() {
        return "FileOptions{context='" + this.context + '\'' + ", loading=" + (Object)((Object)this.loading) + ", cache=" + this.cache + ", walk=" + this.walk + '}';
    }

    public static enum FileLoadingOption {
        PRELOAD,
        MODIFY,
        CACHE,
        LIVE;

    }

    public static class Builder {
        private final FileOptions options = new FileOptions();

        public final Builder setContext(String context) {
            this.options.context = context;
            return this;
        }

        public final Builder setLoadingOption(FileLoadingOption option) {
            this.options.loading = option;
            return this;
        }

        public final Builder setCache(long cache) {
            this.options.cache = cache;
            return this;
        }

        public final Builder setWalk(boolean walk) {
            this.options.walk = walk;
            return this;
        }

        public final FileOptions build() {
            return new FileOptions(this.options);
        }

        public String toString() {
            return "Builder{options=" + this.options + '}';
        }
    }
}

