/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import dev.katsute.simplehttpserver.SimpleHttpExchange;
import dev.katsute.simplehttpserver.SimpleHttpHandler;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeoutHandler
implements SimpleHttpHandler {
    private final HttpHandler handler;
    private final TimeUnit unit;
    private final long timeout;
    private final ExecutorService service = Executors.newCachedThreadPool();

    public TimeoutHandler(HttpHandler handler, double timeout) {
        this(handler, timeout, TimeUnit.SECONDS);
    }

    public TimeoutHandler(HttpHandler handler, double timeout, TimeUnit unit) {
        this.handler = Objects.requireNonNull(handler);
        this.timeout = (long)timeout;
        this.unit = Objects.requireNonNull(unit);
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        SimpleHttpHandler.super.handle(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(SimpleHttpExchange exchange) throws IOException {
        Future<?> future = this.service.submit(() -> {
            try {
                this.handler.handle(exchange);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            future.get(this.timeout, this.unit);
        }
        catch (Throwable e) {
            future.cancel(true);
            exchange.send(408);
            if (!(e instanceof TimeoutException)) {
                throw new RuntimeException(e);
            }
        }
        finally {
            exchange.close();
        }
    }

    public String toString() {
        return "TimeoutHandler{handler=" + this.handler + ", timeout=" + this.timeout + ", unit=" + (Object)((Object)this.unit) + '}';
    }
}

